<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SequenciarEntregas StructType
 * @subpackage Structs
 */
class SequenciarEntregas extends AbstractStructBase
{
    /**
     * The Origem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WayPoint
     */
    public $Origem;
    /**
     * The Entregas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfWayPoint
     */
    public $Entregas;
    /**
     * The Destino
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WayPoint
     */
    public $Destino;
    /**
     * Constructor method for SequenciarEntregas
     * @uses SequenciarEntregas::setOrigem()
     * @uses SequenciarEntregas::setEntregas()
     * @uses SequenciarEntregas::setDestino()
     * @param \StructType\WayPoint $origem
     * @param \ArrayType\ArrayOfWayPoint $entregas
     * @param \StructType\WayPoint $destino
     */
    public function __construct(\StructType\WayPoint $origem = null, \ArrayType\ArrayOfWayPoint $entregas = null, \StructType\WayPoint $destino = null)
    {
        $this
            ->setOrigem($origem)
            ->setEntregas($entregas)
            ->setDestino($destino);
    }
    /**
     * Get Origem value
     * @return \StructType\WayPoint|null
     */
    public function getOrigem()
    {
        return $this->Origem;
    }
    /**
     * Set Origem value
     * @param \StructType\WayPoint $origem
     * @return \StructType\SequenciarEntregas
     */
    public function setOrigem(\StructType\WayPoint $origem = null)
    {
        $this->Origem = $origem;
        return $this;
    }
    /**
     * Get Entregas value
     * @return \ArrayType\ArrayOfWayPoint|null
     */
    public function getEntregas()
    {
        return $this->Entregas;
    }
    /**
     * Set Entregas value
     * @param \ArrayType\ArrayOfWayPoint $entregas
     * @return \StructType\SequenciarEntregas
     */
    public function setEntregas(\ArrayType\ArrayOfWayPoint $entregas = null)
    {
        $this->Entregas = $entregas;
        return $this;
    }
    /**
     * Get Destino value
     * @return \StructType\WayPoint|null
     */
    public function getDestino()
    {
        return $this->Destino;
    }
    /**
     * Set Destino value
     * @param \StructType\WayPoint $destino
     * @return \StructType\SequenciarEntregas
     */
    public function setDestino(\StructType\WayPoint $destino = null)
    {
        $this->Destino = $destino;
        return $this;
    }
}
