<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Retorno StructType
 * @subpackage Structs
 */
class Retorno extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $status;
    /**
     * The motivo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $motivo;
    /**
     * Constructor method for Retorno
     * @uses Retorno::setStatus()
     * @uses Retorno::setMotivo()
     * @param int $status
     * @param string $motivo
     */
    public function __construct($status = null, $motivo = null)
    {
        $this
            ->setStatus($status)
            ->setMotivo($motivo);
    }
    /**
     * Get status value
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\Retorno
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get motivo value
     * @return string|null
     */
    public function getMotivo()
    {
        return $this->motivo;
    }
    /**
     * Set motivo value
     * @param string $motivo
     * @return \StructType\Retorno
     */
    public function setMotivo($motivo = null)
    {
        // validation for constraint: string
        if (!is_null($motivo) && !is_string($motivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivo, true), gettype($motivo)), __LINE__);
        }
        $this->motivo = $motivo;
        return $this;
    }
}
