<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PesquisaRota StructType
 * @subpackage Structs
 */
class PesquisaRota extends AbstractStructBase
{
    /**
     * The Origem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Origem;
    /**
     * The Destino
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Destino;
    /**
     * The Entregas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $Entregas;
    /**
     * Constructor method for PesquisaRota
     * @uses PesquisaRota::setOrigem()
     * @uses PesquisaRota::setDestino()
     * @uses PesquisaRota::setEntregas()
     * @param string $origem
     * @param string $destino
     * @param \ArrayType\ArrayOfString $entregas
     */
    public function __construct($origem = null, $destino = null, \ArrayType\ArrayOfString $entregas = null)
    {
        $this
            ->setOrigem($origem)
            ->setDestino($destino)
            ->setEntregas($entregas);
    }
    /**
     * Get Origem value
     * @return string|null
     */
    public function getOrigem()
    {
        return $this->Origem;
    }
    /**
     * Set Origem value
     * @param string $origem
     * @return \StructType\PesquisaRota
     */
    public function setOrigem($origem = null)
    {
        // validation for constraint: string
        if (!is_null($origem) && !is_string($origem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($origem, true), gettype($origem)), __LINE__);
        }
        $this->Origem = $origem;
        return $this;
    }
    /**
     * Get Destino value
     * @return string|null
     */
    public function getDestino()
    {
        return $this->Destino;
    }
    /**
     * Set Destino value
     * @param string $destino
     * @return \StructType\PesquisaRota
     */
    public function setDestino($destino = null)
    {
        // validation for constraint: string
        if (!is_null($destino) && !is_string($destino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destino, true), gettype($destino)), __LINE__);
        }
        $this->Destino = $destino;
        return $this;
    }
    /**
     * Get Entregas value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getEntregas()
    {
        return $this->Entregas;
    }
    /**
     * Set Entregas value
     * @param \ArrayType\ArrayOfString $entregas
     * @return \StructType\PesquisaRota
     */
    public function setEntregas(\ArrayType\ArrayOfString $entregas = null)
    {
        $this->Entregas = $entregas;
        return $this;
    }
}
