<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetRota StructType
 * @subpackage Structs
 */
class GetRota extends AbstractStructBase
{
    /**
     * The codInicial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $codInicial;
    /**
     * The codFinal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $codFinal;
    /**
     * Constructor method for GetRota
     * @uses GetRota::setCodInicial()
     * @uses GetRota::setCodFinal()
     * @param int $codInicial
     * @param int $codFinal
     */
    public function __construct($codInicial = null, $codFinal = null)
    {
        $this
            ->setCodInicial($codInicial)
            ->setCodFinal($codFinal);
    }
    /**
     * Get codInicial value
     * @return int
     */
    public function getCodInicial()
    {
        return $this->codInicial;
    }
    /**
     * Set codInicial value
     * @param int $codInicial
     * @return \StructType\GetRota
     */
    public function setCodInicial($codInicial = null)
    {
        // validation for constraint: int
        if (!is_null($codInicial) && !(is_int($codInicial) || ctype_digit($codInicial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codInicial, true), gettype($codInicial)), __LINE__);
        }
        $this->codInicial = $codInicial;
        return $this;
    }
    /**
     * Get codFinal value
     * @return int
     */
    public function getCodFinal()
    {
        return $this->codFinal;
    }
    /**
     * Set codFinal value
     * @param int $codFinal
     * @return \StructType\GetRota
     */
    public function setCodFinal($codFinal = null)
    {
        // validation for constraint: int
        if (!is_null($codFinal) && !(is_int($codFinal) || ctype_digit($codFinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codFinal, true), gettype($codFinal)), __LINE__);
        }
        $this->codFinal = $codFinal;
        return $this;
    }
}
