<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancelar ServiceType
 * @subpackage Services
 */
class Cancelar extends AbstractSoapClientBase
{
    /**
     * Sets the ValidationSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ValidationSoapHeader $validationSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderValidationSoapHeader(\StructType\ValidationSoapHeader $validationSoapHeader, $nameSpace = 'http://www.angellira.com.br/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ValidationSoapHeader', $validationSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CancelarEntrega
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelarEntrega $parameters
     * @return \StructType\CancelarEntregaResponse|bool
     */
    public function CancelarEntrega(\StructType\CancelarEntrega $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelarEntrega($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CancelarViagem
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CancelarViagem $parameters
     * @return \StructType\CancelarViagemResponse|bool
     */
    public function CancelarViagem(\StructType\CancelarViagem $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CancelarViagem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CancelarEntregaResponse|\StructType\CancelarViagemResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
