<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cadastrar ServiceType
 * @subpackage Services
 */
class Cadastrar extends AbstractSoapClientBase
{
    /**
     * Sets the ValidationSoapHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ValidationSoapHeader $validationSoapHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderValidationSoapHeader(\StructType\ValidationSoapHeader $validationSoapHeader, $nameSpace = 'http://www.angellira.com.br/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ValidationSoapHeader', $validationSoapHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named CadastrarCliente
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarCliente $parameters
     * @return \StructType\CadastrarClienteResponse|bool
     */
    public function CadastrarCliente(\StructType\CadastrarCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarTipoOcorrencia
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarTipoOcorrencia $parameters
     * @return \StructType\CadastrarTipoOcorrenciaResponse|bool
     */
    public function CadastrarTipoOcorrencia(\StructType\CadastrarTipoOcorrencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarTipoOcorrencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarProduto
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarProduto $parameters
     * @return \StructType\CadastrarProdutoResponse|bool
     */
    public function CadastrarProduto(\StructType\CadastrarProduto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarProduto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarUnidadePagadora
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarUnidadePagadora $parameters
     * @return \StructType\CadastrarUnidadePagadoraResponse|bool
     */
    public function CadastrarUnidadePagadora(\StructType\CadastrarUnidadePagadora $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarUnidadePagadora($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CadastrarAlocacaoDeCusto
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ValidationSoapHeader
     * - SOAPHeaderNamespaces: http://www.angellira.com.br/
     * - SOAPHeaderTypes: \StructType\ValidationSoapHeader
     * - SOAPHeaders: required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CadastrarAlocacaoDeCusto $parameters
     * @return \StructType\CadastrarAlocacaoDeCustoResponse|bool
     */
    public function CadastrarAlocacaoDeCusto(\StructType\CadastrarAlocacaoDeCusto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CadastrarAlocacaoDeCusto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CadastrarAlocacaoDeCustoResponse|\StructType\CadastrarClienteResponse|\StructType\CadastrarProdutoResponse|\StructType\CadastrarTipoOcorrenciaResponse|\StructType\CadastrarUnidadePagadoraResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
