<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfWayPoint ArrayType
 * @subpackage Arrays
 */
class ArrayOfWayPoint extends AbstractStructArrayBase
{
    /**
     * The WayPoint
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WayPoint[]
     */
    public $WayPoint;
    /**
     * Constructor method for ArrayOfWayPoint
     * @uses ArrayOfWayPoint::setWayPoint()
     * @param \StructType\WayPoint[] $wayPoint
     */
    public function __construct(array $wayPoint = array())
    {
        $this
            ->setWayPoint($wayPoint);
    }
    /**
     * Get WayPoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WayPoint[]|null
     */
    public function getWayPoint()
    {
        return isset($this->WayPoint) ? $this->WayPoint : null;
    }
    /**
     * This method is responsible for validating the values passed to the setWayPoint method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWayPoint method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWayPointForArrayConstraintsFromSetWayPoint(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfWayPointWayPointItem) {
            // validation for constraint: itemType
            if (!$arrayOfWayPointWayPointItem instanceof \StructType\WayPoint) {
                $invalidValues[] = is_object($arrayOfWayPointWayPointItem) ? get_class($arrayOfWayPointWayPointItem) : sprintf('%s(%s)', gettype($arrayOfWayPointWayPointItem), var_export($arrayOfWayPointWayPointItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The WayPoint property can only contain items of type \StructType\WayPoint, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set WayPoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WayPoint[] $wayPoint
     * @return \ArrayType\ArrayOfWayPoint
     */
    public function setWayPoint(array $wayPoint = array())
    {
        // validation for constraint: array
        if ('' !== ($wayPointArrayErrorMessage = self::validateWayPointForArrayConstraintsFromSetWayPoint($wayPoint))) {
            throw new \InvalidArgumentException($wayPointArrayErrorMessage, __LINE__);
        }
        if (is_null($wayPoint) || (is_array($wayPoint) && empty($wayPoint))) {
            unset($this->WayPoint);
        } else {
            $this->WayPoint = $wayPoint;
        }
        return $this;
    }
    /**
     * Add item to WayPoint value
     * @throws \InvalidArgumentException
     * @param \StructType\WayPoint $item
     * @return \ArrayType\ArrayOfWayPoint
     */
    public function addToWayPoint(\StructType\WayPoint $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WayPoint) {
            throw new \InvalidArgumentException(sprintf('The WayPoint property can only contain items of type \StructType\WayPoint, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->WayPoint[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\WayPoint|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\WayPoint|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\WayPoint|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\WayPoint|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\WayPoint|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string WayPoint
     */
    public function getAttributeName()
    {
        return 'WayPoint';
    }
}
