<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTrecho ArrayType
 * @subpackage Arrays
 */
class ArrayOfTrecho extends AbstractStructArrayBase
{
    /**
     * The Trecho
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Trecho[]
     */
    public $Trecho;
    /**
     * Constructor method for ArrayOfTrecho
     * @uses ArrayOfTrecho::setTrecho()
     * @param \StructType\Trecho[] $trecho
     */
    public function __construct(array $trecho = array())
    {
        $this
            ->setTrecho($trecho);
    }
    /**
     * Get Trecho value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Trecho[]|null
     */
    public function getTrecho()
    {
        return isset($this->Trecho) ? $this->Trecho : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTrecho method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTrecho method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTrechoForArrayConstraintsFromSetTrecho(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTrechoTrechoItem) {
            // validation for constraint: itemType
            if (!$arrayOfTrechoTrechoItem instanceof \StructType\Trecho) {
                $invalidValues[] = is_object($arrayOfTrechoTrechoItem) ? get_class($arrayOfTrechoTrechoItem) : sprintf('%s(%s)', gettype($arrayOfTrechoTrechoItem), var_export($arrayOfTrechoTrechoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Trecho property can only contain items of type \StructType\Trecho, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Trecho value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Trecho[] $trecho
     * @return \ArrayType\ArrayOfTrecho
     */
    public function setTrecho(array $trecho = array())
    {
        // validation for constraint: array
        if ('' !== ($trechoArrayErrorMessage = self::validateTrechoForArrayConstraintsFromSetTrecho($trecho))) {
            throw new \InvalidArgumentException($trechoArrayErrorMessage, __LINE__);
        }
        if (is_null($trecho) || (is_array($trecho) && empty($trecho))) {
            unset($this->Trecho);
        } else {
            $this->Trecho = $trecho;
        }
        return $this;
    }
    /**
     * Add item to Trecho value
     * @throws \InvalidArgumentException
     * @param \StructType\Trecho $item
     * @return \ArrayType\ArrayOfTrecho
     */
    public function addToTrecho(\StructType\Trecho $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Trecho) {
            throw new \InvalidArgumentException(sprintf('The Trecho property can only contain items of type \StructType\Trecho, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Trecho[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Trecho|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Trecho|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Trecho|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Trecho|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Trecho|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Trecho
     */
    public function getAttributeName()
    {
        return 'Trecho';
    }
}
