<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://sasintegra.sascar.com.br/SasIntegra/SasIntegraWSService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://sasintegra.sascar.com.br/SasIntegra/SasIntegraWSService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Obter ServiceType
 */
$obter = new \ServiceType\Obter($options);
/**
 * Sample call for obterClientes operation/method
 */
if ($obter->obterClientes(new \StructType\ObterClientes()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterMotoristas operation/method
 */
if ($obter->obterMotoristas(new \StructType\ObterMotoristas()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterMotoristasVeiculos operation/method
 */
if ($obter->obterMotoristasVeiculos(new \StructType\ObterMotoristasVeiculos()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterMotoristasPorVeiculo operation/method
 */
if ($obter->obterMotoristasPorVeiculo(new \StructType\ObterMotoristasPorVeiculo()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterLayoutTecladoVeiculos operation/method
 */
if ($obter->obterLayoutTecladoVeiculos(new \StructType\ObterLayoutTecladoVeiculos()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterLayoutGrupoPontos operation/method
 */
if ($obter->obterLayoutGrupoPontos(new \StructType\ObterLayoutGrupoPontos()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterGrupoAtuadores operation/method
 */
if ($obter->obterGrupoAtuadores(new \StructType\ObterGrupoAtuadores()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterStatusComando operation/method
 */
if ($obter->obterStatusComando(new \StructType\ObterStatusComando()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterStatusComandoTicketSascar operation/method
 */
if ($obter->obterStatusComandoTicketSascar(new \StructType\ObterStatusComandoTicketSascar()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterTipoComando operation/method
 */
if ($obter->obterTipoComando(new \StructType\ObterTipoComando()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicoes operation/method
 */
if ($obter->obterPacotePosicoes(new \StructType\ObterPacotePosicoes()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicoesComPlaca operation/method
 */
if ($obter->obterPacotePosicoesComPlaca(new \StructType\ObterPacotePosicoesComPlaca()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicoesMotorista operation/method
 */
if ($obter->obterPacotePosicoesMotorista(new \StructType\ObterPacotePosicoesMotorista()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicoesMotoristaComPlaca operation/method
 */
if ($obter->obterPacotePosicoesMotoristaComPlaca(new \StructType\ObterPacotePosicoesMotoristaComPlaca()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicoesRestricao operation/method
 */
if ($obter->obterPacotePosicoesRestricao(new \StructType\ObterPacotePosicoesRestricao()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicoesMotoristaRestricao operation/method
 */
if ($obter->obterPacotePosicoesMotoristaRestricao(new \StructType\ObterPacotePosicoesMotoristaRestricao()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicoesRFNacional operation/method
 */
if ($obter->obterPacotePosicoesRFNacional(new \StructType\ObterPacotePosicoesRFNacional()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicoesJSON operation/method
 */
if ($obter->obterPacotePosicoesJSON(new \StructType\ObterPacotePosicoesJSON()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicoesJSONComPlaca operation/method
 */
if ($obter->obterPacotePosicoesJSONComPlaca(new \StructType\ObterPacotePosicoesJSONComPlaca()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicoesMotoristaJSON operation/method
 */
if ($obter->obterPacotePosicoesMotoristaJSON(new \StructType\ObterPacotePosicoesMotoristaJSON()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicaoPorRangeJSON operation/method
 */
if ($obter->obterPacotePosicaoPorRangeJSON(new \StructType\ObterPacotePosicaoPorRangeJSON()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicaoPorRange operation/method
 */
if ($obter->obterPacotePosicaoPorRange(new \StructType\ObterPacotePosicaoPorRange()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicaoMotoristaPorRangeJSON operation/method
 */
if ($obter->obterPacotePosicaoMotoristaPorRangeJSON(new \StructType\ObterPacotePosicaoMotoristaPorRangeJSON()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicaoMotoristaPorRange operation/method
 */
if ($obter->obterPacotePosicaoMotoristaPorRange(new \StructType\ObterPacotePosicaoMotoristaPorRange()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicaoHistorico operation/method
 */
if ($obter->obterPacotePosicaoHistorico(new \StructType\ObterPacotePosicaoHistorico()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacotePosicaoMotoristaHistorico operation/method
 */
if ($obter->obterPacotePosicaoMotoristaHistorico(new \StructType\ObterPacotePosicaoMotoristaHistorico()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacoteLocalizacao operation/method
 */
if ($obter->obterPacoteLocalizacao(new \StructType\ObterPacoteLocalizacao()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterMacroTd50Tmcd operation/method
 */
if ($obter->obterMacroTd50Tmcd(new \StructType\ObterMacroTd50Tmcd()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterMacroTd50TmcdDetalhado operation/method
 */
if ($obter->obterMacroTd50TmcdDetalhado(new \StructType\ObterMacroTd50TmcdDetalhado()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterMacroTd40 operation/method
 */
if ($obter->obterMacroTd40(new \StructType\ObterMacroTd40()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterMacroTms3 operation/method
 */
if ($obter->obterMacroTms3(new \StructType\ObterMacroTms3()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterMascaraDispositivos operation/method
 */
if ($obter->obterMascaraDispositivos(new \StructType\ObterMascaraDispositivos()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterLayout operation/method
 */
if ($obter->obterLayout(new \StructType\ObterLayout()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterLayoutData operation/method
 */
if ($obter->obterLayoutData(new \StructType\ObterLayoutData()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterLayoutDetalhado operation/method
 */
if ($obter->obterLayoutDetalhado(new \StructType\ObterLayoutDetalhado()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterVeiculos operation/method
 */
if ($obter->obterVeiculos(new \StructType\ObterVeiculos()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterLayoutAreaAvd operation/method
 */
if ($obter->obterLayoutAreaAvd(new \StructType\ObterLayoutAreaAvd()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterVeiculosRFNacional operation/method
 */
if ($obter->obterVeiculosRFNacional(new \StructType\ObterVeiculosRFNacional()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterVeiculosJson operation/method
 */
if ($obter->obterVeiculosJson(new \StructType\ObterVeiculosJson()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPontosReferencia operation/method
 */
if ($obter->obterPontosReferencia(new \StructType\ObterPontosReferencia()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterSequenciamentoEvento operation/method
 */
if ($obter->obterSequenciamentoEvento(new \StructType\ObterSequenciamentoEvento()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterMensagemPortal operation/method
 */
if ($obter->obterMensagemPortal(new \StructType\ObterMensagemPortal()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterTelemetriaPortal operation/method
 */
if ($obter->obterTelemetriaPortal(new \StructType\ObterTelemetriaPortal()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterEnderecoPosicao operation/method
 */
if ($obter->obterEnderecoPosicao(new \StructType\ObterEnderecoPosicao()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterLayoutAcaoEmbarcadaAVD operation/method
 */
if ($obter->obterLayoutAcaoEmbarcadaAVD(new \StructType\ObterLayoutAcaoEmbarcadaAVD()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterEventoTelemetriaDescricao operation/method
 */
if ($obter->obterEventoTelemetriaDescricao(new \StructType\ObterEventoTelemetriaDescricao()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterEventoTelemetriaIntegracao operation/method
 */
if ($obter->obterEventoTelemetriaIntegracao(new \StructType\ObterEventoTelemetriaIntegracao()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterEventoTelemetriaIntegracaoDataChegada operation/method
 */
if ($obter->obterEventoTelemetriaIntegracaoDataChegada(new \StructType\ObterEventoTelemetriaIntegracaoDataChegada()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterDeltaTelemetriaIntegracao operation/method
 */
if ($obter->obterDeltaTelemetriaIntegracao(new \StructType\ObterDeltaTelemetriaIntegracao()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterDeltaTelemetriaIntegracaoDataChegada operation/method
 */
if ($obter->obterDeltaTelemetriaIntegracaoDataChegada(new \StructType\ObterDeltaTelemetriaIntegracaoDataChegada()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterDadosAdicionais operation/method
 */
if ($obter->obterDadosAdicionais(new \StructType\ObterDadosAdicionais()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterDadosAdicionaisCliente operation/method
 */
if ($obter->obterDadosAdicionaisCliente(new \StructType\ObterDadosAdicionaisCliente()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterEventosTempoDirecao operation/method
 */
if ($obter->obterEventosTempoDirecao(new \StructType\ObterEventosTempoDirecao()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterEventosTempoDirecaoDataChegada operation/method
 */
if ($obter->obterEventosTempoDirecaoDataChegada(new \StructType\ObterEventosTempoDirecaoDataChegada()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterPacoteIntegracaoDeltatelemetria operation/method
 */
if ($obter->obterPacoteIntegracaoDeltatelemetria(new \StructType\ObterPacoteIntegracaoDeltatelemetria()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterDeltaTelemetriaIntegracaoInercia operation/method
 */
if ($obter->obterDeltaTelemetriaIntegracaoInercia(new \StructType\ObterDeltaTelemetriaIntegracaoInercia()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterDeltaTelemetriaIntegracaoInerciaDataChegada
 * operation/method
 */
if ($obter->obterDeltaTelemetriaIntegracaoInerciaDataChegada(new \StructType\ObterDeltaTelemetriaIntegracaoInerciaDataChegada()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterCadastroAlertasAvd operation/method
 */
if ($obter->obterCadastroAlertasAvd(new \StructType\ObterCadastroAlertasAvd()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterAlertasAVDVinculados operation/method
 */
if ($obter->obterAlertasAVDVinculados(new \StructType\ObterAlertasAVDVinculados()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Sample call for obterRotas operation/method
 */
if ($obter->obterRotas(new \StructType\ObterRotas()) !== false) {
    print_r($obter->getResult());
} else {
    print_r($obter->getLastError());
}
/**
 * Samples for Atualizar ServiceType
 */
$atualizar = new \ServiceType\Atualizar($options);
/**
 * Sample call for atualizarSenha operation/method
 */
if ($atualizar->atualizarSenha(new \StructType\AtualizarSenha()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getSmartCamerasEvents operation/method
 */
if ($get->getSmartCamerasEvents(new \StructType\GetSmartCamerasEvents()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPositionsPacketJSON operation/method
 */
if ($get->getPositionsPacketJSON(new \StructType\GetPositionsPacketJSON()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDriverPositionPacketJSON operation/method
 */
if ($get->getDriverPositionPacketJSON(new \StructType\GetDriverPositionPacketJSON()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPositionPacketByRangeJSON operation/method
 */
if ($get->getPositionPacketByRangeJSON(new \StructType\GetPositionPacketByRangeJSON()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDriverPositionPacketByRangeJSON operation/method
 */
if ($get->getDriverPositionPacketByRangeJSON(new \StructType\GetDriverPositionPacketByRangeJSON()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getVehiclesJSON operation/method
 */
if ($get->getVehiclesJSON(new \StructType\GetVehiclesJSON()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getPositionPacketWithLicensePlateJSON operation/method
 */
if ($get->getPositionPacketWithLicensePlateJSON(new \StructType\GetPositionPacketWithLicensePlateJSON()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Verificar ServiceType
 */
$verificar = new \ServiceType\Verificar($options);
/**
 * Sample call for verificarVeiculoIntegrado operation/method
 */
if ($verificar->verificarVeiculoIntegrado(new \StructType\VerificarVeiculoIntegrado()) !== false) {
    print_r($verificar->getResult());
} else {
    print_r($verificar->getLastError());
}
/**
 * Samples for Comando ServiceType
 */
$comando = new \ServiceType\Comando($options);
/**
 * Sample call for comandoEmbarquePontoDiario operation/method
 */
if ($comando->comandoEmbarquePontoDiario(new \StructType\ComandoEmbarquePontoDiario()) !== false) {
    print_r($comando->getResult());
} else {
    print_r($comando->getLastError());
}
/**
 * Samples for Enviar ServiceType
 */
$enviar = new \ServiceType\Enviar($options);
/**
 * Sample call for enviarParametrizacaoTelemetria operation/method
 */
if ($enviar->enviarParametrizacaoTelemetria(new \StructType\EnviarParametrizacaoTelemetria()) !== false) {
    print_r($enviar->getResult());
} else {
    print_r($enviar->getLastError());
}
/**
 * Samples for Solicitar ServiceType
 */
$solicitar = new \ServiceType\Solicitar($options);
/**
 * Sample call for solicitarEventosCaixaPreta operation/method
 */
if ($solicitar->solicitarEventosCaixaPreta(new \StructType\SolicitarEventosCaixaPreta()) !== false) {
    print_r($solicitar->getResult());
} else {
    print_r($solicitar->getLastError());
}
/**
 * Samples for Recuperar ServiceType
 */
$recuperar = new \ServiceType\Recuperar($options);
/**
 * Sample call for recuperarEventosCaixaPreta operation/method
 */
if ($recuperar->recuperarEventosCaixaPreta(new \StructType\RecuperarEventosCaixaPreta()) !== false) {
    print_r($recuperar->getResult());
} else {
    print_r($recuperar->getLastError());
}
/**
 * Samples for Consulta ServiceType
 */
$consulta = new \ServiceType\Consulta($options);
/**
 * Sample call for consultaQuantidadePacotesPosicoesPendentes operation/method
 */
if ($consulta->consultaQuantidadePacotesPosicoesPendentes(new \StructType\ConsultaQuantidadePacotesPosicoesPendentes()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
