<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for telemetriaConfiguracao StructType
 * @subpackage Structs
 */
class TelemetriaConfiguracao extends AbstractStructBase
{
    /**
     * The arrancadaBruscaSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $arrancadaBruscaSensibilidadeInfracao;
    /**
     * The banguelaSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $banguelaSensibilidadeInfracao;
    /**
     * The banguelaVelocidadeMinima
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $banguelaVelocidadeMinima;
    /**
     * The buzzerEstadoEvento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $buzzerEstadoEvento;
    /**
     * The defeitoAlternadorSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $defeitoAlternadorSensibilidadeInfracao;
    /**
     * The defeitoAlternadorTensaoMaxima
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $defeitoAlternadorTensaoMaxima;
    /**
     * The defeitoAlternadorTensaoMinima
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $defeitoAlternadorTensaoMinima;
    /**
     * The defeitoAlternadorTensaoNormalOperacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $defeitoAlternadorTensaoNormalOperacao;
    /**
     * The excessoTempoParadoSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $excessoTempoParadoSensibilidadeInfracao;
    /**
     * The excessoVelocidadeMaximaRodoviarioComChuva
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $excessoVelocidadeMaximaRodoviarioComChuva;
    /**
     * The excessoVelocidadeMaximaRodoviarioSemChuva
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $excessoVelocidadeMaximaRodoviarioSemChuva;
    /**
     * The excessoVelocidadeMaximaTrechoUrbanoComChuva
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $excessoVelocidadeMaximaTrechoUrbanoComChuva;
    /**
     * The excessoVelocidadeMaximaTrechoUrbanoSemChuva
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $excessoVelocidadeMaximaTrechoUrbanoSemChuva;
    /**
     * The excessoVelocidadeSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $excessoVelocidadeSensibilidadeInfracao;
    /**
     * The faixaAzulLimitSuperior
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $faixaAzulLimitSuperior;
    /**
     * The faixaAzulLimiteInferior
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $faixaAzulLimiteInferior;
    /**
     * The faixaVerdeLimiteInferior
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $faixaVerdeLimiteInferior;
    /**
     * The faixaVerdeLimiteSuperior
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $faixaVerdeLimiteSuperior;
    /**
     * The faixaVermelhaLimite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $faixaVermelhaLimite;
    /**
     * The fimChuvaSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $fimChuvaSensibilidadeInfracao;
    /**
     * The freadaBruscaSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $freadaBruscaSensibilidadeInfracao;
    /**
     * The freadaPeFreio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $freadaPeFreio;
    /**
     * The freadaVelocidadeMinima
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $freadaVelocidadeMinima;
    /**
     * The ignicaoExessivaSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ignicaoExessivaSensibilidadeInfracao;
    /**
     * The inicioChuvaSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $inicioChuvaSensibilidadeInfracao;
    /**
     * The marchaLentaExessivaSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $marchaLentaExessivaSensibilidadeInfracao;
    /**
     * The peEmbreagemSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $peEmbreagemSensibilidadeInfracao;
    /**
     * The pressaoOleoSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $pressaoOleoSensibilidadeInfracao;
    /**
     * The rotacaoSensibilidadeInfracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $rotacaoSensibilidadeInfracao;
    /**
     * The tipoVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoVeiculo;
    /**
     * Constructor method for telemetriaConfiguracao
     * @uses TelemetriaConfiguracao::setArrancadaBruscaSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setBanguelaSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setBanguelaVelocidadeMinima()
     * @uses TelemetriaConfiguracao::setBuzzerEstadoEvento()
     * @uses TelemetriaConfiguracao::setDefeitoAlternadorSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setDefeitoAlternadorTensaoMaxima()
     * @uses TelemetriaConfiguracao::setDefeitoAlternadorTensaoMinima()
     * @uses TelemetriaConfiguracao::setDefeitoAlternadorTensaoNormalOperacao()
     * @uses TelemetriaConfiguracao::setExcessoTempoParadoSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setExcessoVelocidadeMaximaRodoviarioComChuva()
     * @uses TelemetriaConfiguracao::setExcessoVelocidadeMaximaRodoviarioSemChuva()
     * @uses TelemetriaConfiguracao::setExcessoVelocidadeMaximaTrechoUrbanoComChuva()
     * @uses TelemetriaConfiguracao::setExcessoVelocidadeMaximaTrechoUrbanoSemChuva()
     * @uses TelemetriaConfiguracao::setExcessoVelocidadeSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setFaixaAzulLimitSuperior()
     * @uses TelemetriaConfiguracao::setFaixaAzulLimiteInferior()
     * @uses TelemetriaConfiguracao::setFaixaVerdeLimiteInferior()
     * @uses TelemetriaConfiguracao::setFaixaVerdeLimiteSuperior()
     * @uses TelemetriaConfiguracao::setFaixaVermelhaLimite()
     * @uses TelemetriaConfiguracao::setFimChuvaSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setFreadaBruscaSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setFreadaPeFreio()
     * @uses TelemetriaConfiguracao::setFreadaVelocidadeMinima()
     * @uses TelemetriaConfiguracao::setIgnicaoExessivaSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setInicioChuvaSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setMarchaLentaExessivaSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setPeEmbreagemSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setPressaoOleoSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setRotacaoSensibilidadeInfracao()
     * @uses TelemetriaConfiguracao::setTipoVeiculo()
     * @param int $arrancadaBruscaSensibilidadeInfracao
     * @param int $banguelaSensibilidadeInfracao
     * @param int $banguelaVelocidadeMinima
     * @param int $buzzerEstadoEvento
     * @param int $defeitoAlternadorSensibilidadeInfracao
     * @param float $defeitoAlternadorTensaoMaxima
     * @param float $defeitoAlternadorTensaoMinima
     * @param int $defeitoAlternadorTensaoNormalOperacao
     * @param int $excessoTempoParadoSensibilidadeInfracao
     * @param int $excessoVelocidadeMaximaRodoviarioComChuva
     * @param int $excessoVelocidadeMaximaRodoviarioSemChuva
     * @param int $excessoVelocidadeMaximaTrechoUrbanoComChuva
     * @param int $excessoVelocidadeMaximaTrechoUrbanoSemChuva
     * @param int $excessoVelocidadeSensibilidadeInfracao
     * @param int $faixaAzulLimitSuperior
     * @param int $faixaAzulLimiteInferior
     * @param int $faixaVerdeLimiteInferior
     * @param int $faixaVerdeLimiteSuperior
     * @param int $faixaVermelhaLimite
     * @param int $fimChuvaSensibilidadeInfracao
     * @param int $freadaBruscaSensibilidadeInfracao
     * @param bool $freadaPeFreio
     * @param int $freadaVelocidadeMinima
     * @param int $ignicaoExessivaSensibilidadeInfracao
     * @param int $inicioChuvaSensibilidadeInfracao
     * @param int $marchaLentaExessivaSensibilidadeInfracao
     * @param int $peEmbreagemSensibilidadeInfracao
     * @param int $pressaoOleoSensibilidadeInfracao
     * @param int $rotacaoSensibilidadeInfracao
     * @param string $tipoVeiculo
     */
    public function __construct($arrancadaBruscaSensibilidadeInfracao = null, $banguelaSensibilidadeInfracao = null, $banguelaVelocidadeMinima = null, $buzzerEstadoEvento = null, $defeitoAlternadorSensibilidadeInfracao = null, $defeitoAlternadorTensaoMaxima = null, $defeitoAlternadorTensaoMinima = null, $defeitoAlternadorTensaoNormalOperacao = null, $excessoTempoParadoSensibilidadeInfracao = null, $excessoVelocidadeMaximaRodoviarioComChuva = null, $excessoVelocidadeMaximaRodoviarioSemChuva = null, $excessoVelocidadeMaximaTrechoUrbanoComChuva = null, $excessoVelocidadeMaximaTrechoUrbanoSemChuva = null, $excessoVelocidadeSensibilidadeInfracao = null, $faixaAzulLimitSuperior = null, $faixaAzulLimiteInferior = null, $faixaVerdeLimiteInferior = null, $faixaVerdeLimiteSuperior = null, $faixaVermelhaLimite = null, $fimChuvaSensibilidadeInfracao = null, $freadaBruscaSensibilidadeInfracao = null, $freadaPeFreio = null, $freadaVelocidadeMinima = null, $ignicaoExessivaSensibilidadeInfracao = null, $inicioChuvaSensibilidadeInfracao = null, $marchaLentaExessivaSensibilidadeInfracao = null, $peEmbreagemSensibilidadeInfracao = null, $pressaoOleoSensibilidadeInfracao = null, $rotacaoSensibilidadeInfracao = null, $tipoVeiculo = null)
    {
        $this
            ->setArrancadaBruscaSensibilidadeInfracao($arrancadaBruscaSensibilidadeInfracao)
            ->setBanguelaSensibilidadeInfracao($banguelaSensibilidadeInfracao)
            ->setBanguelaVelocidadeMinima($banguelaVelocidadeMinima)
            ->setBuzzerEstadoEvento($buzzerEstadoEvento)
            ->setDefeitoAlternadorSensibilidadeInfracao($defeitoAlternadorSensibilidadeInfracao)
            ->setDefeitoAlternadorTensaoMaxima($defeitoAlternadorTensaoMaxima)
            ->setDefeitoAlternadorTensaoMinima($defeitoAlternadorTensaoMinima)
            ->setDefeitoAlternadorTensaoNormalOperacao($defeitoAlternadorTensaoNormalOperacao)
            ->setExcessoTempoParadoSensibilidadeInfracao($excessoTempoParadoSensibilidadeInfracao)
            ->setExcessoVelocidadeMaximaRodoviarioComChuva($excessoVelocidadeMaximaRodoviarioComChuva)
            ->setExcessoVelocidadeMaximaRodoviarioSemChuva($excessoVelocidadeMaximaRodoviarioSemChuva)
            ->setExcessoVelocidadeMaximaTrechoUrbanoComChuva($excessoVelocidadeMaximaTrechoUrbanoComChuva)
            ->setExcessoVelocidadeMaximaTrechoUrbanoSemChuva($excessoVelocidadeMaximaTrechoUrbanoSemChuva)
            ->setExcessoVelocidadeSensibilidadeInfracao($excessoVelocidadeSensibilidadeInfracao)
            ->setFaixaAzulLimitSuperior($faixaAzulLimitSuperior)
            ->setFaixaAzulLimiteInferior($faixaAzulLimiteInferior)
            ->setFaixaVerdeLimiteInferior($faixaVerdeLimiteInferior)
            ->setFaixaVerdeLimiteSuperior($faixaVerdeLimiteSuperior)
            ->setFaixaVermelhaLimite($faixaVermelhaLimite)
            ->setFimChuvaSensibilidadeInfracao($fimChuvaSensibilidadeInfracao)
            ->setFreadaBruscaSensibilidadeInfracao($freadaBruscaSensibilidadeInfracao)
            ->setFreadaPeFreio($freadaPeFreio)
            ->setFreadaVelocidadeMinima($freadaVelocidadeMinima)
            ->setIgnicaoExessivaSensibilidadeInfracao($ignicaoExessivaSensibilidadeInfracao)
            ->setInicioChuvaSensibilidadeInfracao($inicioChuvaSensibilidadeInfracao)
            ->setMarchaLentaExessivaSensibilidadeInfracao($marchaLentaExessivaSensibilidadeInfracao)
            ->setPeEmbreagemSensibilidadeInfracao($peEmbreagemSensibilidadeInfracao)
            ->setPressaoOleoSensibilidadeInfracao($pressaoOleoSensibilidadeInfracao)
            ->setRotacaoSensibilidadeInfracao($rotacaoSensibilidadeInfracao)
            ->setTipoVeiculo($tipoVeiculo);
    }
    /**
     * Get arrancadaBruscaSensibilidadeInfracao value
     * @return int|null
     */
    public function getArrancadaBruscaSensibilidadeInfracao()
    {
        return $this->arrancadaBruscaSensibilidadeInfracao;
    }
    /**
     * Set arrancadaBruscaSensibilidadeInfracao value
     * @param int $arrancadaBruscaSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setArrancadaBruscaSensibilidadeInfracao($arrancadaBruscaSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($arrancadaBruscaSensibilidadeInfracao) && !(is_int($arrancadaBruscaSensibilidadeInfracao) || ctype_digit($arrancadaBruscaSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($arrancadaBruscaSensibilidadeInfracao, true), gettype($arrancadaBruscaSensibilidadeInfracao)), __LINE__);
        }
        $this->arrancadaBruscaSensibilidadeInfracao = $arrancadaBruscaSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get banguelaSensibilidadeInfracao value
     * @return int|null
     */
    public function getBanguelaSensibilidadeInfracao()
    {
        return $this->banguelaSensibilidadeInfracao;
    }
    /**
     * Set banguelaSensibilidadeInfracao value
     * @param int $banguelaSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setBanguelaSensibilidadeInfracao($banguelaSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($banguelaSensibilidadeInfracao) && !(is_int($banguelaSensibilidadeInfracao) || ctype_digit($banguelaSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($banguelaSensibilidadeInfracao, true), gettype($banguelaSensibilidadeInfracao)), __LINE__);
        }
        $this->banguelaSensibilidadeInfracao = $banguelaSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get banguelaVelocidadeMinima value
     * @return int|null
     */
    public function getBanguelaVelocidadeMinima()
    {
        return $this->banguelaVelocidadeMinima;
    }
    /**
     * Set banguelaVelocidadeMinima value
     * @param int $banguelaVelocidadeMinima
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setBanguelaVelocidadeMinima($banguelaVelocidadeMinima = null)
    {
        // validation for constraint: int
        if (!is_null($banguelaVelocidadeMinima) && !(is_int($banguelaVelocidadeMinima) || ctype_digit($banguelaVelocidadeMinima))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($banguelaVelocidadeMinima, true), gettype($banguelaVelocidadeMinima)), __LINE__);
        }
        $this->banguelaVelocidadeMinima = $banguelaVelocidadeMinima;
        return $this;
    }
    /**
     * Get buzzerEstadoEvento value
     * @return int|null
     */
    public function getBuzzerEstadoEvento()
    {
        return $this->buzzerEstadoEvento;
    }
    /**
     * Set buzzerEstadoEvento value
     * @param int $buzzerEstadoEvento
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setBuzzerEstadoEvento($buzzerEstadoEvento = null)
    {
        // validation for constraint: int
        if (!is_null($buzzerEstadoEvento) && !(is_int($buzzerEstadoEvento) || ctype_digit($buzzerEstadoEvento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($buzzerEstadoEvento, true), gettype($buzzerEstadoEvento)), __LINE__);
        }
        $this->buzzerEstadoEvento = $buzzerEstadoEvento;
        return $this;
    }
    /**
     * Get defeitoAlternadorSensibilidadeInfracao value
     * @return int|null
     */
    public function getDefeitoAlternadorSensibilidadeInfracao()
    {
        return $this->defeitoAlternadorSensibilidadeInfracao;
    }
    /**
     * Set defeitoAlternadorSensibilidadeInfracao value
     * @param int $defeitoAlternadorSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setDefeitoAlternadorSensibilidadeInfracao($defeitoAlternadorSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($defeitoAlternadorSensibilidadeInfracao) && !(is_int($defeitoAlternadorSensibilidadeInfracao) || ctype_digit($defeitoAlternadorSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defeitoAlternadorSensibilidadeInfracao, true), gettype($defeitoAlternadorSensibilidadeInfracao)), __LINE__);
        }
        $this->defeitoAlternadorSensibilidadeInfracao = $defeitoAlternadorSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get defeitoAlternadorTensaoMaxima value
     * @return float|null
     */
    public function getDefeitoAlternadorTensaoMaxima()
    {
        return $this->defeitoAlternadorTensaoMaxima;
    }
    /**
     * Set defeitoAlternadorTensaoMaxima value
     * @param float $defeitoAlternadorTensaoMaxima
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setDefeitoAlternadorTensaoMaxima($defeitoAlternadorTensaoMaxima = null)
    {
        // validation for constraint: float
        if (!is_null($defeitoAlternadorTensaoMaxima) && !(is_float($defeitoAlternadorTensaoMaxima) || is_numeric($defeitoAlternadorTensaoMaxima))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defeitoAlternadorTensaoMaxima, true), gettype($defeitoAlternadorTensaoMaxima)), __LINE__);
        }
        $this->defeitoAlternadorTensaoMaxima = $defeitoAlternadorTensaoMaxima;
        return $this;
    }
    /**
     * Get defeitoAlternadorTensaoMinima value
     * @return float|null
     */
    public function getDefeitoAlternadorTensaoMinima()
    {
        return $this->defeitoAlternadorTensaoMinima;
    }
    /**
     * Set defeitoAlternadorTensaoMinima value
     * @param float $defeitoAlternadorTensaoMinima
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setDefeitoAlternadorTensaoMinima($defeitoAlternadorTensaoMinima = null)
    {
        // validation for constraint: float
        if (!is_null($defeitoAlternadorTensaoMinima) && !(is_float($defeitoAlternadorTensaoMinima) || is_numeric($defeitoAlternadorTensaoMinima))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($defeitoAlternadorTensaoMinima, true), gettype($defeitoAlternadorTensaoMinima)), __LINE__);
        }
        $this->defeitoAlternadorTensaoMinima = $defeitoAlternadorTensaoMinima;
        return $this;
    }
    /**
     * Get defeitoAlternadorTensaoNormalOperacao value
     * @return int|null
     */
    public function getDefeitoAlternadorTensaoNormalOperacao()
    {
        return $this->defeitoAlternadorTensaoNormalOperacao;
    }
    /**
     * Set defeitoAlternadorTensaoNormalOperacao value
     * @param int $defeitoAlternadorTensaoNormalOperacao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setDefeitoAlternadorTensaoNormalOperacao($defeitoAlternadorTensaoNormalOperacao = null)
    {
        // validation for constraint: int
        if (!is_null($defeitoAlternadorTensaoNormalOperacao) && !(is_int($defeitoAlternadorTensaoNormalOperacao) || ctype_digit($defeitoAlternadorTensaoNormalOperacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defeitoAlternadorTensaoNormalOperacao, true), gettype($defeitoAlternadorTensaoNormalOperacao)), __LINE__);
        }
        $this->defeitoAlternadorTensaoNormalOperacao = $defeitoAlternadorTensaoNormalOperacao;
        return $this;
    }
    /**
     * Get excessoTempoParadoSensibilidadeInfracao value
     * @return int|null
     */
    public function getExcessoTempoParadoSensibilidadeInfracao()
    {
        return $this->excessoTempoParadoSensibilidadeInfracao;
    }
    /**
     * Set excessoTempoParadoSensibilidadeInfracao value
     * @param int $excessoTempoParadoSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setExcessoTempoParadoSensibilidadeInfracao($excessoTempoParadoSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($excessoTempoParadoSensibilidadeInfracao) && !(is_int($excessoTempoParadoSensibilidadeInfracao) || ctype_digit($excessoTempoParadoSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($excessoTempoParadoSensibilidadeInfracao, true), gettype($excessoTempoParadoSensibilidadeInfracao)), __LINE__);
        }
        $this->excessoTempoParadoSensibilidadeInfracao = $excessoTempoParadoSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get excessoVelocidadeMaximaRodoviarioComChuva value
     * @return int|null
     */
    public function getExcessoVelocidadeMaximaRodoviarioComChuva()
    {
        return $this->excessoVelocidadeMaximaRodoviarioComChuva;
    }
    /**
     * Set excessoVelocidadeMaximaRodoviarioComChuva value
     * @param int $excessoVelocidadeMaximaRodoviarioComChuva
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setExcessoVelocidadeMaximaRodoviarioComChuva($excessoVelocidadeMaximaRodoviarioComChuva = null)
    {
        // validation for constraint: int
        if (!is_null($excessoVelocidadeMaximaRodoviarioComChuva) && !(is_int($excessoVelocidadeMaximaRodoviarioComChuva) || ctype_digit($excessoVelocidadeMaximaRodoviarioComChuva))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($excessoVelocidadeMaximaRodoviarioComChuva, true), gettype($excessoVelocidadeMaximaRodoviarioComChuva)), __LINE__);
        }
        $this->excessoVelocidadeMaximaRodoviarioComChuva = $excessoVelocidadeMaximaRodoviarioComChuva;
        return $this;
    }
    /**
     * Get excessoVelocidadeMaximaRodoviarioSemChuva value
     * @return int|null
     */
    public function getExcessoVelocidadeMaximaRodoviarioSemChuva()
    {
        return $this->excessoVelocidadeMaximaRodoviarioSemChuva;
    }
    /**
     * Set excessoVelocidadeMaximaRodoviarioSemChuva value
     * @param int $excessoVelocidadeMaximaRodoviarioSemChuva
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setExcessoVelocidadeMaximaRodoviarioSemChuva($excessoVelocidadeMaximaRodoviarioSemChuva = null)
    {
        // validation for constraint: int
        if (!is_null($excessoVelocidadeMaximaRodoviarioSemChuva) && !(is_int($excessoVelocidadeMaximaRodoviarioSemChuva) || ctype_digit($excessoVelocidadeMaximaRodoviarioSemChuva))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($excessoVelocidadeMaximaRodoviarioSemChuva, true), gettype($excessoVelocidadeMaximaRodoviarioSemChuva)), __LINE__);
        }
        $this->excessoVelocidadeMaximaRodoviarioSemChuva = $excessoVelocidadeMaximaRodoviarioSemChuva;
        return $this;
    }
    /**
     * Get excessoVelocidadeMaximaTrechoUrbanoComChuva value
     * @return int|null
     */
    public function getExcessoVelocidadeMaximaTrechoUrbanoComChuva()
    {
        return $this->excessoVelocidadeMaximaTrechoUrbanoComChuva;
    }
    /**
     * Set excessoVelocidadeMaximaTrechoUrbanoComChuva value
     * @param int $excessoVelocidadeMaximaTrechoUrbanoComChuva
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setExcessoVelocidadeMaximaTrechoUrbanoComChuva($excessoVelocidadeMaximaTrechoUrbanoComChuva = null)
    {
        // validation for constraint: int
        if (!is_null($excessoVelocidadeMaximaTrechoUrbanoComChuva) && !(is_int($excessoVelocidadeMaximaTrechoUrbanoComChuva) || ctype_digit($excessoVelocidadeMaximaTrechoUrbanoComChuva))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($excessoVelocidadeMaximaTrechoUrbanoComChuva, true), gettype($excessoVelocidadeMaximaTrechoUrbanoComChuva)), __LINE__);
        }
        $this->excessoVelocidadeMaximaTrechoUrbanoComChuva = $excessoVelocidadeMaximaTrechoUrbanoComChuva;
        return $this;
    }
    /**
     * Get excessoVelocidadeMaximaTrechoUrbanoSemChuva value
     * @return int|null
     */
    public function getExcessoVelocidadeMaximaTrechoUrbanoSemChuva()
    {
        return $this->excessoVelocidadeMaximaTrechoUrbanoSemChuva;
    }
    /**
     * Set excessoVelocidadeMaximaTrechoUrbanoSemChuva value
     * @param int $excessoVelocidadeMaximaTrechoUrbanoSemChuva
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setExcessoVelocidadeMaximaTrechoUrbanoSemChuva($excessoVelocidadeMaximaTrechoUrbanoSemChuva = null)
    {
        // validation for constraint: int
        if (!is_null($excessoVelocidadeMaximaTrechoUrbanoSemChuva) && !(is_int($excessoVelocidadeMaximaTrechoUrbanoSemChuva) || ctype_digit($excessoVelocidadeMaximaTrechoUrbanoSemChuva))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($excessoVelocidadeMaximaTrechoUrbanoSemChuva, true), gettype($excessoVelocidadeMaximaTrechoUrbanoSemChuva)), __LINE__);
        }
        $this->excessoVelocidadeMaximaTrechoUrbanoSemChuva = $excessoVelocidadeMaximaTrechoUrbanoSemChuva;
        return $this;
    }
    /**
     * Get excessoVelocidadeSensibilidadeInfracao value
     * @return int|null
     */
    public function getExcessoVelocidadeSensibilidadeInfracao()
    {
        return $this->excessoVelocidadeSensibilidadeInfracao;
    }
    /**
     * Set excessoVelocidadeSensibilidadeInfracao value
     * @param int $excessoVelocidadeSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setExcessoVelocidadeSensibilidadeInfracao($excessoVelocidadeSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($excessoVelocidadeSensibilidadeInfracao) && !(is_int($excessoVelocidadeSensibilidadeInfracao) || ctype_digit($excessoVelocidadeSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($excessoVelocidadeSensibilidadeInfracao, true), gettype($excessoVelocidadeSensibilidadeInfracao)), __LINE__);
        }
        $this->excessoVelocidadeSensibilidadeInfracao = $excessoVelocidadeSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get faixaAzulLimitSuperior value
     * @return int|null
     */
    public function getFaixaAzulLimitSuperior()
    {
        return $this->faixaAzulLimitSuperior;
    }
    /**
     * Set faixaAzulLimitSuperior value
     * @param int $faixaAzulLimitSuperior
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setFaixaAzulLimitSuperior($faixaAzulLimitSuperior = null)
    {
        // validation for constraint: int
        if (!is_null($faixaAzulLimitSuperior) && !(is_int($faixaAzulLimitSuperior) || ctype_digit($faixaAzulLimitSuperior))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($faixaAzulLimitSuperior, true), gettype($faixaAzulLimitSuperior)), __LINE__);
        }
        $this->faixaAzulLimitSuperior = $faixaAzulLimitSuperior;
        return $this;
    }
    /**
     * Get faixaAzulLimiteInferior value
     * @return int|null
     */
    public function getFaixaAzulLimiteInferior()
    {
        return $this->faixaAzulLimiteInferior;
    }
    /**
     * Set faixaAzulLimiteInferior value
     * @param int $faixaAzulLimiteInferior
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setFaixaAzulLimiteInferior($faixaAzulLimiteInferior = null)
    {
        // validation for constraint: int
        if (!is_null($faixaAzulLimiteInferior) && !(is_int($faixaAzulLimiteInferior) || ctype_digit($faixaAzulLimiteInferior))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($faixaAzulLimiteInferior, true), gettype($faixaAzulLimiteInferior)), __LINE__);
        }
        $this->faixaAzulLimiteInferior = $faixaAzulLimiteInferior;
        return $this;
    }
    /**
     * Get faixaVerdeLimiteInferior value
     * @return int|null
     */
    public function getFaixaVerdeLimiteInferior()
    {
        return $this->faixaVerdeLimiteInferior;
    }
    /**
     * Set faixaVerdeLimiteInferior value
     * @param int $faixaVerdeLimiteInferior
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setFaixaVerdeLimiteInferior($faixaVerdeLimiteInferior = null)
    {
        // validation for constraint: int
        if (!is_null($faixaVerdeLimiteInferior) && !(is_int($faixaVerdeLimiteInferior) || ctype_digit($faixaVerdeLimiteInferior))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($faixaVerdeLimiteInferior, true), gettype($faixaVerdeLimiteInferior)), __LINE__);
        }
        $this->faixaVerdeLimiteInferior = $faixaVerdeLimiteInferior;
        return $this;
    }
    /**
     * Get faixaVerdeLimiteSuperior value
     * @return int|null
     */
    public function getFaixaVerdeLimiteSuperior()
    {
        return $this->faixaVerdeLimiteSuperior;
    }
    /**
     * Set faixaVerdeLimiteSuperior value
     * @param int $faixaVerdeLimiteSuperior
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setFaixaVerdeLimiteSuperior($faixaVerdeLimiteSuperior = null)
    {
        // validation for constraint: int
        if (!is_null($faixaVerdeLimiteSuperior) && !(is_int($faixaVerdeLimiteSuperior) || ctype_digit($faixaVerdeLimiteSuperior))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($faixaVerdeLimiteSuperior, true), gettype($faixaVerdeLimiteSuperior)), __LINE__);
        }
        $this->faixaVerdeLimiteSuperior = $faixaVerdeLimiteSuperior;
        return $this;
    }
    /**
     * Get faixaVermelhaLimite value
     * @return int|null
     */
    public function getFaixaVermelhaLimite()
    {
        return $this->faixaVermelhaLimite;
    }
    /**
     * Set faixaVermelhaLimite value
     * @param int $faixaVermelhaLimite
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setFaixaVermelhaLimite($faixaVermelhaLimite = null)
    {
        // validation for constraint: int
        if (!is_null($faixaVermelhaLimite) && !(is_int($faixaVermelhaLimite) || ctype_digit($faixaVermelhaLimite))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($faixaVermelhaLimite, true), gettype($faixaVermelhaLimite)), __LINE__);
        }
        $this->faixaVermelhaLimite = $faixaVermelhaLimite;
        return $this;
    }
    /**
     * Get fimChuvaSensibilidadeInfracao value
     * @return int|null
     */
    public function getFimChuvaSensibilidadeInfracao()
    {
        return $this->fimChuvaSensibilidadeInfracao;
    }
    /**
     * Set fimChuvaSensibilidadeInfracao value
     * @param int $fimChuvaSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setFimChuvaSensibilidadeInfracao($fimChuvaSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($fimChuvaSensibilidadeInfracao) && !(is_int($fimChuvaSensibilidadeInfracao) || ctype_digit($fimChuvaSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fimChuvaSensibilidadeInfracao, true), gettype($fimChuvaSensibilidadeInfracao)), __LINE__);
        }
        $this->fimChuvaSensibilidadeInfracao = $fimChuvaSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get freadaBruscaSensibilidadeInfracao value
     * @return int|null
     */
    public function getFreadaBruscaSensibilidadeInfracao()
    {
        return $this->freadaBruscaSensibilidadeInfracao;
    }
    /**
     * Set freadaBruscaSensibilidadeInfracao value
     * @param int $freadaBruscaSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setFreadaBruscaSensibilidadeInfracao($freadaBruscaSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($freadaBruscaSensibilidadeInfracao) && !(is_int($freadaBruscaSensibilidadeInfracao) || ctype_digit($freadaBruscaSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($freadaBruscaSensibilidadeInfracao, true), gettype($freadaBruscaSensibilidadeInfracao)), __LINE__);
        }
        $this->freadaBruscaSensibilidadeInfracao = $freadaBruscaSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get freadaPeFreio value
     * @return bool|null
     */
    public function getFreadaPeFreio()
    {
        return $this->freadaPeFreio;
    }
    /**
     * Set freadaPeFreio value
     * @param bool $freadaPeFreio
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setFreadaPeFreio($freadaPeFreio = null)
    {
        // validation for constraint: boolean
        if (!is_null($freadaPeFreio) && !is_bool($freadaPeFreio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($freadaPeFreio, true), gettype($freadaPeFreio)), __LINE__);
        }
        $this->freadaPeFreio = $freadaPeFreio;
        return $this;
    }
    /**
     * Get freadaVelocidadeMinima value
     * @return int|null
     */
    public function getFreadaVelocidadeMinima()
    {
        return $this->freadaVelocidadeMinima;
    }
    /**
     * Set freadaVelocidadeMinima value
     * @param int $freadaVelocidadeMinima
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setFreadaVelocidadeMinima($freadaVelocidadeMinima = null)
    {
        // validation for constraint: int
        if (!is_null($freadaVelocidadeMinima) && !(is_int($freadaVelocidadeMinima) || ctype_digit($freadaVelocidadeMinima))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($freadaVelocidadeMinima, true), gettype($freadaVelocidadeMinima)), __LINE__);
        }
        $this->freadaVelocidadeMinima = $freadaVelocidadeMinima;
        return $this;
    }
    /**
     * Get ignicaoExessivaSensibilidadeInfracao value
     * @return int|null
     */
    public function getIgnicaoExessivaSensibilidadeInfracao()
    {
        return $this->ignicaoExessivaSensibilidadeInfracao;
    }
    /**
     * Set ignicaoExessivaSensibilidadeInfracao value
     * @param int $ignicaoExessivaSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setIgnicaoExessivaSensibilidadeInfracao($ignicaoExessivaSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($ignicaoExessivaSensibilidadeInfracao) && !(is_int($ignicaoExessivaSensibilidadeInfracao) || ctype_digit($ignicaoExessivaSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ignicaoExessivaSensibilidadeInfracao, true), gettype($ignicaoExessivaSensibilidadeInfracao)), __LINE__);
        }
        $this->ignicaoExessivaSensibilidadeInfracao = $ignicaoExessivaSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get inicioChuvaSensibilidadeInfracao value
     * @return int|null
     */
    public function getInicioChuvaSensibilidadeInfracao()
    {
        return $this->inicioChuvaSensibilidadeInfracao;
    }
    /**
     * Set inicioChuvaSensibilidadeInfracao value
     * @param int $inicioChuvaSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setInicioChuvaSensibilidadeInfracao($inicioChuvaSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($inicioChuvaSensibilidadeInfracao) && !(is_int($inicioChuvaSensibilidadeInfracao) || ctype_digit($inicioChuvaSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($inicioChuvaSensibilidadeInfracao, true), gettype($inicioChuvaSensibilidadeInfracao)), __LINE__);
        }
        $this->inicioChuvaSensibilidadeInfracao = $inicioChuvaSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get marchaLentaExessivaSensibilidadeInfracao value
     * @return int|null
     */
    public function getMarchaLentaExessivaSensibilidadeInfracao()
    {
        return $this->marchaLentaExessivaSensibilidadeInfracao;
    }
    /**
     * Set marchaLentaExessivaSensibilidadeInfracao value
     * @param int $marchaLentaExessivaSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setMarchaLentaExessivaSensibilidadeInfracao($marchaLentaExessivaSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($marchaLentaExessivaSensibilidadeInfracao) && !(is_int($marchaLentaExessivaSensibilidadeInfracao) || ctype_digit($marchaLentaExessivaSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($marchaLentaExessivaSensibilidadeInfracao, true), gettype($marchaLentaExessivaSensibilidadeInfracao)), __LINE__);
        }
        $this->marchaLentaExessivaSensibilidadeInfracao = $marchaLentaExessivaSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get peEmbreagemSensibilidadeInfracao value
     * @return int|null
     */
    public function getPeEmbreagemSensibilidadeInfracao()
    {
        return $this->peEmbreagemSensibilidadeInfracao;
    }
    /**
     * Set peEmbreagemSensibilidadeInfracao value
     * @param int $peEmbreagemSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setPeEmbreagemSensibilidadeInfracao($peEmbreagemSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($peEmbreagemSensibilidadeInfracao) && !(is_int($peEmbreagemSensibilidadeInfracao) || ctype_digit($peEmbreagemSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($peEmbreagemSensibilidadeInfracao, true), gettype($peEmbreagemSensibilidadeInfracao)), __LINE__);
        }
        $this->peEmbreagemSensibilidadeInfracao = $peEmbreagemSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get pressaoOleoSensibilidadeInfracao value
     * @return int|null
     */
    public function getPressaoOleoSensibilidadeInfracao()
    {
        return $this->pressaoOleoSensibilidadeInfracao;
    }
    /**
     * Set pressaoOleoSensibilidadeInfracao value
     * @param int $pressaoOleoSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setPressaoOleoSensibilidadeInfracao($pressaoOleoSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($pressaoOleoSensibilidadeInfracao) && !(is_int($pressaoOleoSensibilidadeInfracao) || ctype_digit($pressaoOleoSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pressaoOleoSensibilidadeInfracao, true), gettype($pressaoOleoSensibilidadeInfracao)), __LINE__);
        }
        $this->pressaoOleoSensibilidadeInfracao = $pressaoOleoSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get rotacaoSensibilidadeInfracao value
     * @return int|null
     */
    public function getRotacaoSensibilidadeInfracao()
    {
        return $this->rotacaoSensibilidadeInfracao;
    }
    /**
     * Set rotacaoSensibilidadeInfracao value
     * @param int $rotacaoSensibilidadeInfracao
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setRotacaoSensibilidadeInfracao($rotacaoSensibilidadeInfracao = null)
    {
        // validation for constraint: int
        if (!is_null($rotacaoSensibilidadeInfracao) && !(is_int($rotacaoSensibilidadeInfracao) || ctype_digit($rotacaoSensibilidadeInfracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rotacaoSensibilidadeInfracao, true), gettype($rotacaoSensibilidadeInfracao)), __LINE__);
        }
        $this->rotacaoSensibilidadeInfracao = $rotacaoSensibilidadeInfracao;
        return $this;
    }
    /**
     * Get tipoVeiculo value
     * @return string|null
     */
    public function getTipoVeiculo()
    {
        return $this->tipoVeiculo;
    }
    /**
     * Set tipoVeiculo value
     * @param string $tipoVeiculo
     * @return \StructType\TelemetriaConfiguracao
     */
    public function setTipoVeiculo($tipoVeiculo = null)
    {
        // validation for constraint: string
        if (!is_null($tipoVeiculo) && !is_string($tipoVeiculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoVeiculo, true), gettype($tipoVeiculo)), __LINE__);
        }
        $this->tipoVeiculo = $tipoVeiculo;
        return $this;
    }
}
