<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for smartCamerasPayload StructType
 * @subpackage Structs
 */
class SmartCamerasPayload extends AbstractStructBase
{
    /**
     * The camera
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $camera;
    /**
     * The data_size
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $data_size;
    /**
     * The direction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $direction;
    /**
     * The driver_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $driver_id;
    /**
     * The event_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $event_id;
    /**
     * The file
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $file;
    /**
     * The gps_valid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $gps_valid;
    /**
     * The lat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lat;
    /**
     * The lon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lon;
    /**
     * The num_cams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $num_cams;
    /**
     * The num_sats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $num_sats;
    /**
     * The perclos_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $perclos_id;
    /**
     * The perclos_value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $perclos_value;
    /**
     * The request_id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $request_id;
    /**
     * The resolution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resolution;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timestamp;
    /**
     * The upload_duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $upload_duration;
    /**
     * The vel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $vel;
    /**
     * The video_duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $video_duration;
    /**
     * Constructor method for smartCamerasPayload
     * @uses SmartCamerasPayload::setCamera()
     * @uses SmartCamerasPayload::setData_size()
     * @uses SmartCamerasPayload::setDirection()
     * @uses SmartCamerasPayload::setDriver_id()
     * @uses SmartCamerasPayload::setEvent_id()
     * @uses SmartCamerasPayload::setFile()
     * @uses SmartCamerasPayload::setGps_valid()
     * @uses SmartCamerasPayload::setLat()
     * @uses SmartCamerasPayload::setLon()
     * @uses SmartCamerasPayload::setNum_cams()
     * @uses SmartCamerasPayload::setNum_sats()
     * @uses SmartCamerasPayload::setPerclos_id()
     * @uses SmartCamerasPayload::setPerclos_value()
     * @uses SmartCamerasPayload::setRequest_id()
     * @uses SmartCamerasPayload::setResolution()
     * @uses SmartCamerasPayload::setTimestamp()
     * @uses SmartCamerasPayload::setUpload_duration()
     * @uses SmartCamerasPayload::setVel()
     * @uses SmartCamerasPayload::setVideo_duration()
     * @param string $camera
     * @param string $data_size
     * @param string $direction
     * @param string $driver_id
     * @param string $event_id
     * @param string $file
     * @param string $gps_valid
     * @param string $lat
     * @param string $lon
     * @param string $num_cams
     * @param string $num_sats
     * @param string $perclos_id
     * @param string $perclos_value
     * @param string $request_id
     * @param string $resolution
     * @param string $timestamp
     * @param string $upload_duration
     * @param string $vel
     * @param string $video_duration
     */
    public function __construct($camera = null, $data_size = null, $direction = null, $driver_id = null, $event_id = null, $file = null, $gps_valid = null, $lat = null, $lon = null, $num_cams = null, $num_sats = null, $perclos_id = null, $perclos_value = null, $request_id = null, $resolution = null, $timestamp = null, $upload_duration = null, $vel = null, $video_duration = null)
    {
        $this
            ->setCamera($camera)
            ->setData_size($data_size)
            ->setDirection($direction)
            ->setDriver_id($driver_id)
            ->setEvent_id($event_id)
            ->setFile($file)
            ->setGps_valid($gps_valid)
            ->setLat($lat)
            ->setLon($lon)
            ->setNum_cams($num_cams)
            ->setNum_sats($num_sats)
            ->setPerclos_id($perclos_id)
            ->setPerclos_value($perclos_value)
            ->setRequest_id($request_id)
            ->setResolution($resolution)
            ->setTimestamp($timestamp)
            ->setUpload_duration($upload_duration)
            ->setVel($vel)
            ->setVideo_duration($video_duration);
    }
    /**
     * Get camera value
     * @return string|null
     */
    public function getCamera()
    {
        return $this->camera;
    }
    /**
     * Set camera value
     * @param string $camera
     * @return \StructType\SmartCamerasPayload
     */
    public function setCamera($camera = null)
    {
        // validation for constraint: string
        if (!is_null($camera) && !is_string($camera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($camera, true), gettype($camera)), __LINE__);
        }
        $this->camera = $camera;
        return $this;
    }
    /**
     * Get data_size value
     * @return string|null
     */
    public function getData_size()
    {
        return $this->data_size;
    }
    /**
     * Set data_size value
     * @param string $data_size
     * @return \StructType\SmartCamerasPayload
     */
    public function setData_size($data_size = null)
    {
        // validation for constraint: string
        if (!is_null($data_size) && !is_string($data_size)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data_size, true), gettype($data_size)), __LINE__);
        }
        $this->data_size = $data_size;
        return $this;
    }
    /**
     * Get direction value
     * @return string|null
     */
    public function getDirection()
    {
        return $this->direction;
    }
    /**
     * Set direction value
     * @param string $direction
     * @return \StructType\SmartCamerasPayload
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: string
        if (!is_null($direction) && !is_string($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($direction, true), gettype($direction)), __LINE__);
        }
        $this->direction = $direction;
        return $this;
    }
    /**
     * Get driver_id value
     * @return string|null
     */
    public function getDriver_id()
    {
        return $this->driver_id;
    }
    /**
     * Set driver_id value
     * @param string $driver_id
     * @return \StructType\SmartCamerasPayload
     */
    public function setDriver_id($driver_id = null)
    {
        // validation for constraint: string
        if (!is_null($driver_id) && !is_string($driver_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driver_id, true), gettype($driver_id)), __LINE__);
        }
        $this->driver_id = $driver_id;
        return $this;
    }
    /**
     * Get event_id value
     * @return string|null
     */
    public function getEvent_id()
    {
        return $this->event_id;
    }
    /**
     * Set event_id value
     * @param string $event_id
     * @return \StructType\SmartCamerasPayload
     */
    public function setEvent_id($event_id = null)
    {
        // validation for constraint: string
        if (!is_null($event_id) && !is_string($event_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($event_id, true), gettype($event_id)), __LINE__);
        }
        $this->event_id = $event_id;
        return $this;
    }
    /**
     * Get file value
     * @return string|null
     */
    public function getFile()
    {
        return $this->file;
    }
    /**
     * Set file value
     * @param string $file
     * @return \StructType\SmartCamerasPayload
     */
    public function setFile($file = null)
    {
        // validation for constraint: string
        if (!is_null($file) && !is_string($file)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($file, true), gettype($file)), __LINE__);
        }
        $this->file = $file;
        return $this;
    }
    /**
     * Get gps_valid value
     * @return string|null
     */
    public function getGps_valid()
    {
        return $this->gps_valid;
    }
    /**
     * Set gps_valid value
     * @param string $gps_valid
     * @return \StructType\SmartCamerasPayload
     */
    public function setGps_valid($gps_valid = null)
    {
        // validation for constraint: string
        if (!is_null($gps_valid) && !is_string($gps_valid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gps_valid, true), gettype($gps_valid)), __LINE__);
        }
        $this->gps_valid = $gps_valid;
        return $this;
    }
    /**
     * Get lat value
     * @return string|null
     */
    public function getLat()
    {
        return $this->lat;
    }
    /**
     * Set lat value
     * @param string $lat
     * @return \StructType\SmartCamerasPayload
     */
    public function setLat($lat = null)
    {
        // validation for constraint: string
        if (!is_null($lat) && !is_string($lat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lat, true), gettype($lat)), __LINE__);
        }
        $this->lat = $lat;
        return $this;
    }
    /**
     * Get lon value
     * @return string|null
     */
    public function getLon()
    {
        return $this->lon;
    }
    /**
     * Set lon value
     * @param string $lon
     * @return \StructType\SmartCamerasPayload
     */
    public function setLon($lon = null)
    {
        // validation for constraint: string
        if (!is_null($lon) && !is_string($lon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lon, true), gettype($lon)), __LINE__);
        }
        $this->lon = $lon;
        return $this;
    }
    /**
     * Get num_cams value
     * @return string|null
     */
    public function getNum_cams()
    {
        return $this->num_cams;
    }
    /**
     * Set num_cams value
     * @param string $num_cams
     * @return \StructType\SmartCamerasPayload
     */
    public function setNum_cams($num_cams = null)
    {
        // validation for constraint: string
        if (!is_null($num_cams) && !is_string($num_cams)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($num_cams, true), gettype($num_cams)), __LINE__);
        }
        $this->num_cams = $num_cams;
        return $this;
    }
    /**
     * Get num_sats value
     * @return string|null
     */
    public function getNum_sats()
    {
        return $this->num_sats;
    }
    /**
     * Set num_sats value
     * @param string $num_sats
     * @return \StructType\SmartCamerasPayload
     */
    public function setNum_sats($num_sats = null)
    {
        // validation for constraint: string
        if (!is_null($num_sats) && !is_string($num_sats)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($num_sats, true), gettype($num_sats)), __LINE__);
        }
        $this->num_sats = $num_sats;
        return $this;
    }
    /**
     * Get perclos_id value
     * @return string|null
     */
    public function getPerclos_id()
    {
        return $this->perclos_id;
    }
    /**
     * Set perclos_id value
     * @param string $perclos_id
     * @return \StructType\SmartCamerasPayload
     */
    public function setPerclos_id($perclos_id = null)
    {
        // validation for constraint: string
        if (!is_null($perclos_id) && !is_string($perclos_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($perclos_id, true), gettype($perclos_id)), __LINE__);
        }
        $this->perclos_id = $perclos_id;
        return $this;
    }
    /**
     * Get perclos_value value
     * @return string|null
     */
    public function getPerclos_value()
    {
        return $this->perclos_value;
    }
    /**
     * Set perclos_value value
     * @param string $perclos_value
     * @return \StructType\SmartCamerasPayload
     */
    public function setPerclos_value($perclos_value = null)
    {
        // validation for constraint: string
        if (!is_null($perclos_value) && !is_string($perclos_value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($perclos_value, true), gettype($perclos_value)), __LINE__);
        }
        $this->perclos_value = $perclos_value;
        return $this;
    }
    /**
     * Get request_id value
     * @return string|null
     */
    public function getRequest_id()
    {
        return $this->request_id;
    }
    /**
     * Set request_id value
     * @param string $request_id
     * @return \StructType\SmartCamerasPayload
     */
    public function setRequest_id($request_id = null)
    {
        // validation for constraint: string
        if (!is_null($request_id) && !is_string($request_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request_id, true), gettype($request_id)), __LINE__);
        }
        $this->request_id = $request_id;
        return $this;
    }
    /**
     * Get resolution value
     * @return string|null
     */
    public function getResolution()
    {
        return $this->resolution;
    }
    /**
     * Set resolution value
     * @param string $resolution
     * @return \StructType\SmartCamerasPayload
     */
    public function setResolution($resolution = null)
    {
        // validation for constraint: string
        if (!is_null($resolution) && !is_string($resolution)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resolution, true), gettype($resolution)), __LINE__);
        }
        $this->resolution = $resolution;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\SmartCamerasPayload
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get upload_duration value
     * @return string|null
     */
    public function getUpload_duration()
    {
        return $this->upload_duration;
    }
    /**
     * Set upload_duration value
     * @param string $upload_duration
     * @return \StructType\SmartCamerasPayload
     */
    public function setUpload_duration($upload_duration = null)
    {
        // validation for constraint: string
        if (!is_null($upload_duration) && !is_string($upload_duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($upload_duration, true), gettype($upload_duration)), __LINE__);
        }
        $this->upload_duration = $upload_duration;
        return $this;
    }
    /**
     * Get vel value
     * @return string|null
     */
    public function getVel()
    {
        return $this->vel;
    }
    /**
     * Set vel value
     * @param string $vel
     * @return \StructType\SmartCamerasPayload
     */
    public function setVel($vel = null)
    {
        // validation for constraint: string
        if (!is_null($vel) && !is_string($vel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vel, true), gettype($vel)), __LINE__);
        }
        $this->vel = $vel;
        return $this;
    }
    /**
     * Get video_duration value
     * @return string|null
     */
    public function getVideo_duration()
    {
        return $this->video_duration;
    }
    /**
     * Set video_duration value
     * @param string $video_duration
     * @return \StructType\SmartCamerasPayload
     */
    public function setVideo_duration($video_duration = null)
    {
        // validation for constraint: string
        if (!is_null($video_duration) && !is_string($video_duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($video_duration, true), gettype($video_duration)), __LINE__);
        }
        $this->video_duration = $video_duration;
        return $this;
    }
}
