<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for pacoteLocalizacao StructType
 * @subpackage Structs
 */
class PacoteLocalizacao extends AbstractStructBase
{
    /**
     * The dataPacote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataPacote;
    /**
     * The direcao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $direcao;
    /**
     * The gps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $gps;
    /**
     * The idVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idVeiculo;
    /**
     * The ignicao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ignicao;
    /**
     * The latitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $latitude;
    /**
     * The longitude
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $longitude;
    /**
     * The velocidade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $velocidade;
    /**
     * Constructor method for pacoteLocalizacao
     * @uses PacoteLocalizacao::setDataPacote()
     * @uses PacoteLocalizacao::setDirecao()
     * @uses PacoteLocalizacao::setGps()
     * @uses PacoteLocalizacao::setIdVeiculo()
     * @uses PacoteLocalizacao::setIgnicao()
     * @uses PacoteLocalizacao::setLatitude()
     * @uses PacoteLocalizacao::setLongitude()
     * @uses PacoteLocalizacao::setVelocidade()
     * @param string $dataPacote
     * @param int $direcao
     * @param int $gps
     * @param int $idVeiculo
     * @param int $ignicao
     * @param float $latitude
     * @param float $longitude
     * @param int $velocidade
     */
    public function __construct($dataPacote = null, $direcao = null, $gps = null, $idVeiculo = null, $ignicao = null, $latitude = null, $longitude = null, $velocidade = null)
    {
        $this
            ->setDataPacote($dataPacote)
            ->setDirecao($direcao)
            ->setGps($gps)
            ->setIdVeiculo($idVeiculo)
            ->setIgnicao($ignicao)
            ->setLatitude($latitude)
            ->setLongitude($longitude)
            ->setVelocidade($velocidade);
    }
    /**
     * Get dataPacote value
     * @return string|null
     */
    public function getDataPacote()
    {
        return $this->dataPacote;
    }
    /**
     * Set dataPacote value
     * @param string $dataPacote
     * @return \StructType\PacoteLocalizacao
     */
    public function setDataPacote($dataPacote = null)
    {
        // validation for constraint: string
        if (!is_null($dataPacote) && !is_string($dataPacote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataPacote, true), gettype($dataPacote)), __LINE__);
        }
        $this->dataPacote = $dataPacote;
        return $this;
    }
    /**
     * Get direcao value
     * @return int|null
     */
    public function getDirecao()
    {
        return $this->direcao;
    }
    /**
     * Set direcao value
     * @param int $direcao
     * @return \StructType\PacoteLocalizacao
     */
    public function setDirecao($direcao = null)
    {
        // validation for constraint: int
        if (!is_null($direcao) && !(is_int($direcao) || ctype_digit($direcao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($direcao, true), gettype($direcao)), __LINE__);
        }
        $this->direcao = $direcao;
        return $this;
    }
    /**
     * Get gps value
     * @return int|null
     */
    public function getGps()
    {
        return $this->gps;
    }
    /**
     * Set gps value
     * @param int $gps
     * @return \StructType\PacoteLocalizacao
     */
    public function setGps($gps = null)
    {
        // validation for constraint: int
        if (!is_null($gps) && !(is_int($gps) || ctype_digit($gps))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gps, true), gettype($gps)), __LINE__);
        }
        $this->gps = $gps;
        return $this;
    }
    /**
     * Get idVeiculo value
     * @return int|null
     */
    public function getIdVeiculo()
    {
        return $this->idVeiculo;
    }
    /**
     * Set idVeiculo value
     * @param int $idVeiculo
     * @return \StructType\PacoteLocalizacao
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: int
        if (!is_null($idVeiculo) && !(is_int($idVeiculo) || ctype_digit($idVeiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->idVeiculo = $idVeiculo;
        return $this;
    }
    /**
     * Get ignicao value
     * @return int|null
     */
    public function getIgnicao()
    {
        return $this->ignicao;
    }
    /**
     * Set ignicao value
     * @param int $ignicao
     * @return \StructType\PacoteLocalizacao
     */
    public function setIgnicao($ignicao = null)
    {
        // validation for constraint: int
        if (!is_null($ignicao) && !(is_int($ignicao) || ctype_digit($ignicao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ignicao, true), gettype($ignicao)), __LINE__);
        }
        $this->ignicao = $ignicao;
        return $this;
    }
    /**
     * Get latitude value
     * @return float|null
     */
    public function getLatitude()
    {
        return $this->latitude;
    }
    /**
     * Set latitude value
     * @param float $latitude
     * @return \StructType\PacoteLocalizacao
     */
    public function setLatitude($latitude = null)
    {
        // validation for constraint: float
        if (!is_null($latitude) && !(is_float($latitude) || is_numeric($latitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitude, true), gettype($latitude)), __LINE__);
        }
        $this->latitude = $latitude;
        return $this;
    }
    /**
     * Get longitude value
     * @return float|null
     */
    public function getLongitude()
    {
        return $this->longitude;
    }
    /**
     * Set longitude value
     * @param float $longitude
     * @return \StructType\PacoteLocalizacao
     */
    public function setLongitude($longitude = null)
    {
        // validation for constraint: float
        if (!is_null($longitude) && !(is_float($longitude) || is_numeric($longitude))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitude, true), gettype($longitude)), __LINE__);
        }
        $this->longitude = $longitude;
        return $this;
    }
    /**
     * Get velocidade value
     * @return int|null
     */
    public function getVelocidade()
    {
        return $this->velocidade;
    }
    /**
     * Set velocidade value
     * @param int $velocidade
     * @return \StructType\PacoteLocalizacao
     */
    public function setVelocidade($velocidade = null)
    {
        // validation for constraint: int
        if (!is_null($velocidade) && !(is_int($velocidade) || ctype_digit($velocidade))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($velocidade, true), gettype($velocidade)), __LINE__);
        }
        $this->velocidade = $velocidade;
        return $this;
    }
}
