<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for obterVeiculos StructType
 * Meta information extracted from the WSDL
 * - type: ns0:obterVeiculos
 * @subpackage Structs
 */
class ObterVeiculos extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senha;
    /**
     * The quantidade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantidade;
    /**
     * The idVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idVeiculo;
    /**
     * Constructor method for obterVeiculos
     * @uses ObterVeiculos::setUsuario()
     * @uses ObterVeiculos::setSenha()
     * @uses ObterVeiculos::setQuantidade()
     * @uses ObterVeiculos::setIdVeiculo()
     * @param string $usuario
     * @param string $senha
     * @param int $quantidade
     * @param int $idVeiculo
     */
    public function __construct($usuario = null, $senha = null, $quantidade = null, $idVeiculo = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setQuantidade($quantidade)
            ->setIdVeiculo($idVeiculo);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\ObterVeiculos
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->senha;
    }
    /**
     * Set senha value
     * @param string $senha
     * @return \StructType\ObterVeiculos
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->senha = $senha;
        return $this;
    }
    /**
     * Get quantidade value
     * @return int|null
     */
    public function getQuantidade()
    {
        return $this->quantidade;
    }
    /**
     * Set quantidade value
     * @param int $quantidade
     * @return \StructType\ObterVeiculos
     */
    public function setQuantidade($quantidade = null)
    {
        // validation for constraint: int
        if (!is_null($quantidade) && !(is_int($quantidade) || ctype_digit($quantidade))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantidade, true), gettype($quantidade)), __LINE__);
        }
        $this->quantidade = $quantidade;
        return $this;
    }
    /**
     * Get idVeiculo value
     * @return int|null
     */
    public function getIdVeiculo()
    {
        return $this->idVeiculo;
    }
    /**
     * Set idVeiculo value
     * @param int $idVeiculo
     * @return \StructType\ObterVeiculos
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: int
        if (!is_null($idVeiculo) && !(is_int($idVeiculo) || ctype_digit($idVeiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->idVeiculo = $idVeiculo;
        return $this;
    }
}
