<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for obterStatusComando StructType
 * Meta information extracted from the WSDL
 * - type: ns0:obterStatusComando
 * @subpackage Structs
 */
class ObterStatusComando extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senha;
    /**
     * The ticket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ticket;
    /**
     * Constructor method for obterStatusComando
     * @uses ObterStatusComando::setUsuario()
     * @uses ObterStatusComando::setSenha()
     * @uses ObterStatusComando::setTicket()
     * @param string $usuario
     * @param string $senha
     * @param int $ticket
     */
    public function __construct($usuario = null, $senha = null, $ticket = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setTicket($ticket);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\ObterStatusComando
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->senha;
    }
    /**
     * Set senha value
     * @param string $senha
     * @return \StructType\ObterStatusComando
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->senha = $senha;
        return $this;
    }
    /**
     * Get ticket value
     * @return int|null
     */
    public function getTicket()
    {
        return $this->ticket;
    }
    /**
     * Set ticket value
     * @param int $ticket
     * @return \StructType\ObterStatusComando
     */
    public function setTicket($ticket = null)
    {
        // validation for constraint: int
        if (!is_null($ticket) && !(is_int($ticket) || ctype_digit($ticket))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticket, true), gettype($ticket)), __LINE__);
        }
        $this->ticket = $ticket;
        return $this;
    }
}
