<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for obterMotoristasVeiculos StructType
 * Meta information extracted from the WSDL
 * - type: ns0:obterMotoristasVeiculos
 * @subpackage Structs
 */
class ObterMotoristasVeiculos extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senha;
    /**
     * The quantidade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantidade;
    /**
     * The idMotoristaVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idMotoristaVeiculo;
    /**
     * Constructor method for obterMotoristasVeiculos
     * @uses ObterMotoristasVeiculos::setUsuario()
     * @uses ObterMotoristasVeiculos::setSenha()
     * @uses ObterMotoristasVeiculos::setQuantidade()
     * @uses ObterMotoristasVeiculos::setIdMotoristaVeiculo()
     * @param string $usuario
     * @param string $senha
     * @param int $quantidade
     * @param int $idMotoristaVeiculo
     */
    public function __construct($usuario = null, $senha = null, $quantidade = null, $idMotoristaVeiculo = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setQuantidade($quantidade)
            ->setIdMotoristaVeiculo($idMotoristaVeiculo);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\ObterMotoristasVeiculos
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->senha;
    }
    /**
     * Set senha value
     * @param string $senha
     * @return \StructType\ObterMotoristasVeiculos
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->senha = $senha;
        return $this;
    }
    /**
     * Get quantidade value
     * @return int|null
     */
    public function getQuantidade()
    {
        return $this->quantidade;
    }
    /**
     * Set quantidade value
     * @param int $quantidade
     * @return \StructType\ObterMotoristasVeiculos
     */
    public function setQuantidade($quantidade = null)
    {
        // validation for constraint: int
        if (!is_null($quantidade) && !(is_int($quantidade) || ctype_digit($quantidade))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantidade, true), gettype($quantidade)), __LINE__);
        }
        $this->quantidade = $quantidade;
        return $this;
    }
    /**
     * Get idMotoristaVeiculo value
     * @return int|null
     */
    public function getIdMotoristaVeiculo()
    {
        return $this->idMotoristaVeiculo;
    }
    /**
     * Set idMotoristaVeiculo value
     * @param int $idMotoristaVeiculo
     * @return \StructType\ObterMotoristasVeiculos
     */
    public function setIdMotoristaVeiculo($idMotoristaVeiculo = null)
    {
        // validation for constraint: int
        if (!is_null($idMotoristaVeiculo) && !(is_int($idMotoristaVeiculo) || ctype_digit($idMotoristaVeiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idMotoristaVeiculo, true), gettype($idMotoristaVeiculo)), __LINE__);
        }
        $this->idMotoristaVeiculo = $idMotoristaVeiculo;
        return $this;
    }
}
