<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for obterLayoutData StructType
 * Meta information extracted from the WSDL
 * - type: ns0:obterLayoutData
 * @subpackage Structs
 */
class ObterLayoutData extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senha;
    /**
     * The layout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $layout;
    /**
     * Constructor method for obterLayoutData
     * @uses ObterLayoutData::setUsuario()
     * @uses ObterLayoutData::setSenha()
     * @uses ObterLayoutData::setLayout()
     * @param string $usuario
     * @param string $senha
     * @param string $layout
     */
    public function __construct($usuario = null, $senha = null, $layout = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setLayout($layout);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\ObterLayoutData
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->senha;
    }
    /**
     * Set senha value
     * @param string $senha
     * @return \StructType\ObterLayoutData
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->senha = $senha;
        return $this;
    }
    /**
     * Get layout value
     * @return string|null
     */
    public function getLayout()
    {
        return $this->layout;
    }
    /**
     * Set layout value
     * @uses \EnumType\TipoLayout::valueIsValid()
     * @uses \EnumType\TipoLayout::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $layout
     * @return \StructType\ObterLayoutData
     */
    public function setLayout($layout = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoLayout::valueIsValid($layout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoLayout', is_array($layout) ? implode(', ', $layout) : var_export($layout, true), implode(', ', \EnumType\TipoLayout::getValidValues())), __LINE__);
        }
        $this->layout = $layout;
        return $this;
    }
}
