<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for motorista StructType
 * @subpackage Structs
 */
class Motorista extends AbstractStructBase
{
    /**
     * The celular
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $celular;
    /**
     * The dataContratacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $dataContratacao;
    /**
     * The generico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $generico;
    /**
     * The idMotorista
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idMotorista;
    /**
     * The login
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $login;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nome;
    /**
     * The numeroDocumento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $numeroDocumento;
    /**
     * The senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senha;
    /**
     * The telefone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $telefone;
    /**
     * The tipoCNH
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoCNH;
    /**
     * The tipoDocumento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoDocumento;
    /**
     * The tipoMotorista
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoMotorista;
    /**
     * The vencimentoCNH
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var anySimpleType
     */
    public $vencimentoCNH;
    /**
     * Constructor method for motorista
     * @uses Motorista::setCelular()
     * @uses Motorista::setDataContratacao()
     * @uses Motorista::setGenerico()
     * @uses Motorista::setIdMotorista()
     * @uses Motorista::setLogin()
     * @uses Motorista::setNome()
     * @uses Motorista::setNumeroDocumento()
     * @uses Motorista::setSenha()
     * @uses Motorista::setTelefone()
     * @uses Motorista::setTipoCNH()
     * @uses Motorista::setTipoDocumento()
     * @uses Motorista::setTipoMotorista()
     * @uses Motorista::setVencimentoCNH()
     * @param string $celular
     * @param anySimpleType $dataContratacao
     * @param bool $generico
     * @param int $idMotorista
     * @param string $login
     * @param string $nome
     * @param string $numeroDocumento
     * @param string $senha
     * @param string $telefone
     * @param string $tipoCNH
     * @param string $tipoDocumento
     * @param string $tipoMotorista
     * @param anySimpleType $vencimentoCNH
     */
    public function __construct($celular = null, anySimpleType $dataContratacao = null, $generico = null, $idMotorista = null, $login = null, $nome = null, $numeroDocumento = null, $senha = null, $telefone = null, $tipoCNH = null, $tipoDocumento = null, $tipoMotorista = null, anySimpleType $vencimentoCNH = null)
    {
        $this
            ->setCelular($celular)
            ->setDataContratacao($dataContratacao)
            ->setGenerico($generico)
            ->setIdMotorista($idMotorista)
            ->setLogin($login)
            ->setNome($nome)
            ->setNumeroDocumento($numeroDocumento)
            ->setSenha($senha)
            ->setTelefone($telefone)
            ->setTipoCNH($tipoCNH)
            ->setTipoDocumento($tipoDocumento)
            ->setTipoMotorista($tipoMotorista)
            ->setVencimentoCNH($vencimentoCNH);
    }
    /**
     * Get celular value
     * @return string|null
     */
    public function getCelular()
    {
        return $this->celular;
    }
    /**
     * Set celular value
     * @param string $celular
     * @return \StructType\Motorista
     */
    public function setCelular($celular = null)
    {
        // validation for constraint: string
        if (!is_null($celular) && !is_string($celular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($celular, true), gettype($celular)), __LINE__);
        }
        $this->celular = $celular;
        return $this;
    }
    /**
     * Get dataContratacao value
     * @return anySimpleType|null
     */
    public function getDataContratacao()
    {
        return $this->dataContratacao;
    }
    /**
     * Set dataContratacao value
     * @param anySimpleType $dataContratacao
     * @return \StructType\Motorista
     */
    public function setDataContratacao(anySimpleType $dataContratacao = null)
    {
        $this->dataContratacao = $dataContratacao;
        return $this;
    }
    /**
     * Get generico value
     * @return bool|null
     */
    public function getGenerico()
    {
        return $this->generico;
    }
    /**
     * Set generico value
     * @param bool $generico
     * @return \StructType\Motorista
     */
    public function setGenerico($generico = null)
    {
        // validation for constraint: boolean
        if (!is_null($generico) && !is_bool($generico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generico, true), gettype($generico)), __LINE__);
        }
        $this->generico = $generico;
        return $this;
    }
    /**
     * Get idMotorista value
     * @return int|null
     */
    public function getIdMotorista()
    {
        return $this->idMotorista;
    }
    /**
     * Set idMotorista value
     * @param int $idMotorista
     * @return \StructType\Motorista
     */
    public function setIdMotorista($idMotorista = null)
    {
        // validation for constraint: int
        if (!is_null($idMotorista) && !(is_int($idMotorista) || ctype_digit($idMotorista))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idMotorista, true), gettype($idMotorista)), __LINE__);
        }
        $this->idMotorista = $idMotorista;
        return $this;
    }
    /**
     * Get login value
     * @return string|null
     */
    public function getLogin()
    {
        return $this->login;
    }
    /**
     * Set login value
     * @param string $login
     * @return \StructType\Motorista
     */
    public function setLogin($login = null)
    {
        // validation for constraint: string
        if (!is_null($login) && !is_string($login)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($login, true), gettype($login)), __LINE__);
        }
        $this->login = $login;
        return $this;
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \StructType\Motorista
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
    /**
     * Get numeroDocumento value
     * @return string|null
     */
    public function getNumeroDocumento()
    {
        return $this->numeroDocumento;
    }
    /**
     * Set numeroDocumento value
     * @param string $numeroDocumento
     * @return \StructType\Motorista
     */
    public function setNumeroDocumento($numeroDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDocumento) && !is_string($numeroDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDocumento, true), gettype($numeroDocumento)), __LINE__);
        }
        $this->numeroDocumento = $numeroDocumento;
        return $this;
    }
    /**
     * Get senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->senha;
    }
    /**
     * Set senha value
     * @param string $senha
     * @return \StructType\Motorista
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->senha = $senha;
        return $this;
    }
    /**
     * Get telefone value
     * @return string|null
     */
    public function getTelefone()
    {
        return $this->telefone;
    }
    /**
     * Set telefone value
     * @param string $telefone
     * @return \StructType\Motorista
     */
    public function setTelefone($telefone = null)
    {
        // validation for constraint: string
        if (!is_null($telefone) && !is_string($telefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefone, true), gettype($telefone)), __LINE__);
        }
        $this->telefone = $telefone;
        return $this;
    }
    /**
     * Get tipoCNH value
     * @return string|null
     */
    public function getTipoCNH()
    {
        return $this->tipoCNH;
    }
    /**
     * Set tipoCNH value
     * @param string $tipoCNH
     * @return \StructType\Motorista
     */
    public function setTipoCNH($tipoCNH = null)
    {
        // validation for constraint: string
        if (!is_null($tipoCNH) && !is_string($tipoCNH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoCNH, true), gettype($tipoCNH)), __LINE__);
        }
        $this->tipoCNH = $tipoCNH;
        return $this;
    }
    /**
     * Get tipoDocumento value
     * @return string|null
     */
    public function getTipoDocumento()
    {
        return $this->tipoDocumento;
    }
    /**
     * Set tipoDocumento value
     * @param string $tipoDocumento
     * @return \StructType\Motorista
     */
    public function setTipoDocumento($tipoDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumento) && !is_string($tipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDocumento, true), gettype($tipoDocumento)), __LINE__);
        }
        $this->tipoDocumento = $tipoDocumento;
        return $this;
    }
    /**
     * Get tipoMotorista value
     * @return string|null
     */
    public function getTipoMotorista()
    {
        return $this->tipoMotorista;
    }
    /**
     * Set tipoMotorista value
     * @param string $tipoMotorista
     * @return \StructType\Motorista
     */
    public function setTipoMotorista($tipoMotorista = null)
    {
        // validation for constraint: string
        if (!is_null($tipoMotorista) && !is_string($tipoMotorista)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoMotorista, true), gettype($tipoMotorista)), __LINE__);
        }
        $this->tipoMotorista = $tipoMotorista;
        return $this;
    }
    /**
     * Get vencimentoCNH value
     * @return anySimpleType|null
     */
    public function getVencimentoCNH()
    {
        return $this->vencimentoCNH;
    }
    /**
     * Set vencimentoCNH value
     * @param anySimpleType $vencimentoCNH
     * @return \StructType\Motorista
     */
    public function setVencimentoCNH(anySimpleType $vencimentoCNH = null)
    {
        $this->vencimentoCNH = $vencimentoCNH;
        return $this;
    }
}
