<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for macro StructType
 * @subpackage Structs
 */
class Macro extends AbstractStructBase
{
    /**
     * The desricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $desricao;
    /**
     * The idMacro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idMacro;
    /**
     * The layout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $layout;
    /**
     * Constructor method for macro
     * @uses Macro::setDesricao()
     * @uses Macro::setIdMacro()
     * @uses Macro::setLayout()
     * @param string $desricao
     * @param int $idMacro
     * @param string $layout
     */
    public function __construct($desricao = null, $idMacro = null, $layout = null)
    {
        $this
            ->setDesricao($desricao)
            ->setIdMacro($idMacro)
            ->setLayout($layout);
    }
    /**
     * Get desricao value
     * @return string|null
     */
    public function getDesricao()
    {
        return $this->desricao;
    }
    /**
     * Set desricao value
     * @param string $desricao
     * @return \StructType\Macro
     */
    public function setDesricao($desricao = null)
    {
        // validation for constraint: string
        if (!is_null($desricao) && !is_string($desricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($desricao, true), gettype($desricao)), __LINE__);
        }
        $this->desricao = $desricao;
        return $this;
    }
    /**
     * Get idMacro value
     * @return int|null
     */
    public function getIdMacro()
    {
        return $this->idMacro;
    }
    /**
     * Set idMacro value
     * @param int $idMacro
     * @return \StructType\Macro
     */
    public function setIdMacro($idMacro = null)
    {
        // validation for constraint: int
        if (!is_null($idMacro) && !(is_int($idMacro) || ctype_digit($idMacro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idMacro, true), gettype($idMacro)), __LINE__);
        }
        $this->idMacro = $idMacro;
        return $this;
    }
    /**
     * Get layout value
     * @return string|null
     */
    public function getLayout()
    {
        return $this->layout;
    }
    /**
     * Set layout value
     * @param string $layout
     * @return \StructType\Macro
     */
    public function setLayout($layout = null)
    {
        // validation for constraint: string
        if (!is_null($layout) && !is_string($layout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($layout, true), gettype($layout)), __LINE__);
        }
        $this->layout = $layout;
        return $this;
    }
}
