<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for layoutDetalhado StructType
 * @subpackage Structs
 */
class LayoutDetalhado extends AbstractStructBase
{
    /**
     * The descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descricao;
    /**
     * The idLayout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idLayout;
    /**
     * The macros
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Macro[]
     */
    public $macros;
    /**
     * Constructor method for layoutDetalhado
     * @uses LayoutDetalhado::setDescricao()
     * @uses LayoutDetalhado::setIdLayout()
     * @uses LayoutDetalhado::setMacros()
     * @param string $descricao
     * @param int $idLayout
     * @param \StructType\Macro[] $macros
     */
    public function __construct($descricao = null, $idLayout = null, array $macros = array())
    {
        $this
            ->setDescricao($descricao)
            ->setIdLayout($idLayout)
            ->setMacros($macros);
    }
    /**
     * Get descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\LayoutDetalhado
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
    /**
     * Get idLayout value
     * @return int|null
     */
    public function getIdLayout()
    {
        return $this->idLayout;
    }
    /**
     * Set idLayout value
     * @param int $idLayout
     * @return \StructType\LayoutDetalhado
     */
    public function setIdLayout($idLayout = null)
    {
        // validation for constraint: int
        if (!is_null($idLayout) && !(is_int($idLayout) || ctype_digit($idLayout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idLayout, true), gettype($idLayout)), __LINE__);
        }
        $this->idLayout = $idLayout;
        return $this;
    }
    /**
     * Get macros value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Macro[]|null
     */
    public function getMacros()
    {
        return isset($this->macros) ? $this->macros : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMacros method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMacros method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMacrosForArrayConstraintsFromSetMacros(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $layoutDetalhadoMacrosItem) {
            // validation for constraint: itemType
            if (!$layoutDetalhadoMacrosItem instanceof \StructType\Macro) {
                $invalidValues[] = is_object($layoutDetalhadoMacrosItem) ? get_class($layoutDetalhadoMacrosItem) : sprintf('%s(%s)', gettype($layoutDetalhadoMacrosItem), var_export($layoutDetalhadoMacrosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The macros property can only contain items of type \StructType\Macro, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set macros value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Macro[] $macros
     * @return \StructType\LayoutDetalhado
     */
    public function setMacros(array $macros = array())
    {
        // validation for constraint: array
        if ('' !== ($macrosArrayErrorMessage = self::validateMacrosForArrayConstraintsFromSetMacros($macros))) {
            throw new \InvalidArgumentException($macrosArrayErrorMessage, __LINE__);
        }
        if (is_null($macros) || (is_array($macros) && empty($macros))) {
            unset($this->macros);
        } else {
            $this->macros = $macros;
        }
        return $this;
    }
    /**
     * Add item to macros value
     * @throws \InvalidArgumentException
     * @param \StructType\Macro $item
     * @return \StructType\LayoutDetalhado
     */
    public function addToMacros(\StructType\Macro $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Macro) {
            throw new \InvalidArgumentException(sprintf('The macros property can only contain items of type \StructType\Macro, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->macros[] = $item;
        return $this;
    }
}
