<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for enviarParametrizacaoTelemetria StructType
 * Meta information extracted from the WSDL
 * - type: ns0:enviarParametrizacaoTelemetria
 * @subpackage Structs
 */
class EnviarParametrizacaoTelemetria extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senha;
    /**
     * The idVeiculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idVeiculo;
    /**
     * The telemetriaParametrizacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TelemetriaConfiguracao
     */
    public $telemetriaParametrizacao;
    /**
     * Constructor method for enviarParametrizacaoTelemetria
     * @uses EnviarParametrizacaoTelemetria::setUsuario()
     * @uses EnviarParametrizacaoTelemetria::setSenha()
     * @uses EnviarParametrizacaoTelemetria::setIdVeiculo()
     * @uses EnviarParametrizacaoTelemetria::setTelemetriaParametrizacao()
     * @param string $usuario
     * @param string $senha
     * @param int $idVeiculo
     * @param \StructType\TelemetriaConfiguracao $telemetriaParametrizacao
     */
    public function __construct($usuario = null, $senha = null, $idVeiculo = null, \StructType\TelemetriaConfiguracao $telemetriaParametrizacao = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setIdVeiculo($idVeiculo)
            ->setTelemetriaParametrizacao($telemetriaParametrizacao);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\EnviarParametrizacaoTelemetria
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->senha;
    }
    /**
     * Set senha value
     * @param string $senha
     * @return \StructType\EnviarParametrizacaoTelemetria
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->senha = $senha;
        return $this;
    }
    /**
     * Get idVeiculo value
     * @return int|null
     */
    public function getIdVeiculo()
    {
        return $this->idVeiculo;
    }
    /**
     * Set idVeiculo value
     * @param int $idVeiculo
     * @return \StructType\EnviarParametrizacaoTelemetria
     */
    public function setIdVeiculo($idVeiculo = null)
    {
        // validation for constraint: int
        if (!is_null($idVeiculo) && !(is_int($idVeiculo) || ctype_digit($idVeiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idVeiculo, true), gettype($idVeiculo)), __LINE__);
        }
        $this->idVeiculo = $idVeiculo;
        return $this;
    }
    /**
     * Get telemetriaParametrizacao value
     * @return \StructType\TelemetriaConfiguracao|null
     */
    public function getTelemetriaParametrizacao()
    {
        return $this->telemetriaParametrizacao;
    }
    /**
     * Set telemetriaParametrizacao value
     * @param \StructType\TelemetriaConfiguracao $telemetriaParametrizacao
     * @return \StructType\EnviarParametrizacaoTelemetria
     */
    public function setTelemetriaParametrizacao(\StructType\TelemetriaConfiguracao $telemetriaParametrizacao = null)
    {
        $this->telemetriaParametrizacao = $telemetriaParametrizacao;
        return $this;
    }
}
