<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Verificar ServiceType
 * @subpackage Services
 */
class Verificar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named verificarVeiculoIntegrado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VerificarVeiculoIntegrado $parameters
     * @return \StructType\VerificarVeiculoIntegradoResponse|bool
     */
    public function verificarVeiculoIntegrado(\StructType\VerificarVeiculoIntegrado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->verificarVeiculoIntegrado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VerificarVeiculoIntegradoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
