<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Obter ServiceType
 * @subpackage Services
 */
class Obter extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named obterClientes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterClientes $parameters
     * @return \StructType\ObterClientesResponse|bool
     */
    public function obterClientes(\StructType\ObterClientes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterClientes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterMotoristas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterMotoristas $parameters
     * @return \StructType\ObterMotoristasResponse|bool
     */
    public function obterMotoristas(\StructType\ObterMotoristas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterMotoristas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterMotoristasVeiculos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterMotoristasVeiculos $parameters
     * @return \StructType\ObterMotoristasVeiculosResponse|bool
     */
    public function obterMotoristasVeiculos(\StructType\ObterMotoristasVeiculos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterMotoristasVeiculos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterMotoristasPorVeiculo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterMotoristasPorVeiculo $parameters
     * @return \StructType\ObterMotoristasPorVeiculoResponse|bool
     */
    public function obterMotoristasPorVeiculo(\StructType\ObterMotoristasPorVeiculo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterMotoristasPorVeiculo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterLayoutTecladoVeiculos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterLayoutTecladoVeiculos $parameters
     * @return \StructType\ObterLayoutTecladoVeiculosResponse|bool
     */
    public function obterLayoutTecladoVeiculos(\StructType\ObterLayoutTecladoVeiculos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterLayoutTecladoVeiculos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterLayoutGrupoPontos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterLayoutGrupoPontos $parameters
     * @return \StructType\ObterLayoutGrupoPontosResponse|bool
     */
    public function obterLayoutGrupoPontos(\StructType\ObterLayoutGrupoPontos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterLayoutGrupoPontos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterGrupoAtuadores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterGrupoAtuadores $parameters
     * @return \StructType\ObterGrupoAtuadoresResponse|bool
     */
    public function obterGrupoAtuadores(\StructType\ObterGrupoAtuadores $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterGrupoAtuadores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterStatusComando
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterStatusComando $parameters
     * @return \StructType\ObterStatusComandoResponse|bool
     */
    public function obterStatusComando(\StructType\ObterStatusComando $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterStatusComando($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterStatusComandoTicketSascar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterStatusComandoTicketSascar $parameters
     * @return \StructType\ObterStatusComandoTicketSascarResponse|bool
     */
    public function obterStatusComandoTicketSascar(\StructType\ObterStatusComandoTicketSascar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterStatusComandoTicketSascar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterTipoComando
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterTipoComando $parameters
     * @return \StructType\ObterTipoComandoResponse|bool
     */
    public function obterTipoComando(\StructType\ObterTipoComando $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterTipoComando($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacotePosicoes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicoes $parameters
     * @return \StructType\ObterPacotePosicoesResponse|bool
     */
    public function obterPacotePosicoes(\StructType\ObterPacotePosicoes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicoes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacotePosicoesComPlaca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicoesComPlaca $parameters
     * @return \StructType\ObterPacotePosicoesComPlacaResponse|bool
     */
    public function obterPacotePosicoesComPlaca(\StructType\ObterPacotePosicoesComPlaca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicoesComPlaca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacotePosicoesMotorista
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicoesMotorista $parameters
     * @return \StructType\ObterPacotePosicoesMotoristaResponse|bool
     */
    public function obterPacotePosicoesMotorista(\StructType\ObterPacotePosicoesMotorista $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicoesMotorista($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * obterPacotePosicoesMotoristaComPlaca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicoesMotoristaComPlaca $parameters
     * @return \StructType\ObterPacotePosicoesMotoristaComPlacaResponse|bool
     */
    public function obterPacotePosicoesMotoristaComPlaca(\StructType\ObterPacotePosicoesMotoristaComPlaca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicoesMotoristaComPlaca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacotePosicoesRestricao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicoesRestricao $parameters
     * @return \StructType\ObterPacotePosicoesRestricaoResponse|bool
     */
    public function obterPacotePosicoesRestricao(\StructType\ObterPacotePosicoesRestricao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicoesRestricao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * obterPacotePosicoesMotoristaRestricao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicoesMotoristaRestricao $parameters
     * @return \StructType\ObterPacotePosicoesMotoristaRestricaoResponse|bool
     */
    public function obterPacotePosicoesMotoristaRestricao(\StructType\ObterPacotePosicoesMotoristaRestricao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicoesMotoristaRestricao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacotePosicoesRFNacional
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicoesRFNacional $parameters
     * @return \StructType\ObterPacotePosicoesRFNacionalResponse|bool
     */
    public function obterPacotePosicoesRFNacional(\StructType\ObterPacotePosicoesRFNacional $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicoesRFNacional($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacotePosicoesJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicoesJSON $parameters
     * @return \StructType\ObterPacotePosicoesJSONResponse|bool
     */
    public function obterPacotePosicoesJSON(\StructType\ObterPacotePosicoesJSON $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicoesJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacotePosicoesJSONComPlaca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicoesJSONComPlaca $parameters
     * @return \StructType\ObterPacotePosicoesJSONComPlacaResponse|bool
     */
    public function obterPacotePosicoesJSONComPlaca(\StructType\ObterPacotePosicoesJSONComPlaca $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicoesJSONComPlaca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacotePosicoesMotoristaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicoesMotoristaJSON $parameters
     * @return \StructType\ObterPacotePosicoesMotoristaJSONResponse|bool
     */
    public function obterPacotePosicoesMotoristaJSON(\StructType\ObterPacotePosicoesMotoristaJSON $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicoesMotoristaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacotePosicaoPorRangeJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicaoPorRangeJSON $parameters
     * @return \StructType\ObterPacotePosicaoPorRangeJSONResponse|bool
     */
    public function obterPacotePosicaoPorRangeJSON(\StructType\ObterPacotePosicaoPorRangeJSON $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicaoPorRangeJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacotePosicaoPorRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicaoPorRange $parameters
     * @return \StructType\ObterPacotePosicaoPorRangeResponse|bool
     */
    public function obterPacotePosicaoPorRange(\StructType\ObterPacotePosicaoPorRange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicaoPorRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * obterPacotePosicaoMotoristaPorRangeJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicaoMotoristaPorRangeJSON $parameters
     * @return \StructType\ObterPacotePosicaoMotoristaPorRangeJSONResponse|bool
     */
    public function obterPacotePosicaoMotoristaPorRangeJSON(\StructType\ObterPacotePosicaoMotoristaPorRangeJSON $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicaoMotoristaPorRangeJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * obterPacotePosicaoMotoristaPorRange
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicaoMotoristaPorRange $parameters
     * @return \StructType\ObterPacotePosicaoMotoristaPorRangeResponse|bool
     */
    public function obterPacotePosicaoMotoristaPorRange(\StructType\ObterPacotePosicaoMotoristaPorRange $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicaoMotoristaPorRange($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacotePosicaoHistorico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicaoHistorico $parameters
     * @return \StructType\ObterPacotePosicaoHistoricoResponse|bool
     */
    public function obterPacotePosicaoHistorico(\StructType\ObterPacotePosicaoHistorico $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicaoHistorico($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * obterPacotePosicaoMotoristaHistorico
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacotePosicaoMotoristaHistorico $parameters
     * @return \StructType\ObterPacotePosicaoMotoristaHistoricoResponse|bool
     */
    public function obterPacotePosicaoMotoristaHistorico(\StructType\ObterPacotePosicaoMotoristaHistorico $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacotePosicaoMotoristaHistorico($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPacoteLocalizacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacoteLocalizacao $parameters
     * @return \StructType\ObterPacoteLocalizacaoResponse|bool
     */
    public function obterPacoteLocalizacao(\StructType\ObterPacoteLocalizacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacoteLocalizacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterMacroTd50Tmcd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterMacroTd50Tmcd $parameters
     * @return \StructType\ObterMacroTd50TmcdResponse|bool
     */
    public function obterMacroTd50Tmcd(\StructType\ObterMacroTd50Tmcd $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterMacroTd50Tmcd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterMacroTd50TmcdDetalhado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterMacroTd50TmcdDetalhado $parameters
     * @return \StructType\ObterMacroTd50TmcdDetalhadoResponse|bool
     */
    public function obterMacroTd50TmcdDetalhado(\StructType\ObterMacroTd50TmcdDetalhado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterMacroTd50TmcdDetalhado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterMacroTd40
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterMacroTd40 $parameters
     * @return \StructType\ObterMacroTd40Response|bool
     */
    public function obterMacroTd40(\StructType\ObterMacroTd40 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterMacroTd40($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterMacroTms3
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterMacroTms3 $parameters
     * @return \StructType\ObterMacroTms3Response|bool
     */
    public function obterMacroTms3(\StructType\ObterMacroTms3 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterMacroTms3($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterMascaraDispositivos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterMascaraDispositivos $parameters
     * @return \StructType\ObterMascaraDispositivosResponse|bool
     */
    public function obterMascaraDispositivos(\StructType\ObterMascaraDispositivos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterMascaraDispositivos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterLayout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterLayout $parameters
     * @return \StructType\ObterLayoutResponse|bool
     */
    public function obterLayout(\StructType\ObterLayout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterLayout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterLayoutData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterLayoutData $parameters
     * @return \StructType\ObterLayoutDataResponse|bool
     */
    public function obterLayoutData(\StructType\ObterLayoutData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterLayoutData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterLayoutDetalhado
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterLayoutDetalhado $parameters
     * @return \StructType\ObterLayoutDetalhadoResponse|bool
     */
    public function obterLayoutDetalhado(\StructType\ObterLayoutDetalhado $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterLayoutDetalhado($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterVeiculos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterVeiculos $parameters
     * @return \StructType\ObterVeiculosResponse|bool
     */
    public function obterVeiculos(\StructType\ObterVeiculos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterVeiculos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterLayoutAreaAvd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterLayoutAreaAvd $parameters
     * @return \StructType\ObterLayoutAreaAvdResponse|bool
     */
    public function obterLayoutAreaAvd(\StructType\ObterLayoutAreaAvd $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterLayoutAreaAvd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterVeiculosRFNacional
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterVeiculosRFNacional $parameters
     * @return \StructType\ObterVeiculosRFNacionalResponse|bool
     */
    public function obterVeiculosRFNacional(\StructType\ObterVeiculosRFNacional $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterVeiculosRFNacional($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterVeiculosJson
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterVeiculosJson $parameters
     * @return \StructType\ObterVeiculosJsonResponse|bool
     */
    public function obterVeiculosJson(\StructType\ObterVeiculosJson $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterVeiculosJson($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterPontosReferencia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPontosReferencia $parameters
     * @return \StructType\ObterPontosReferenciaResponse|bool
     */
    public function obterPontosReferencia(\StructType\ObterPontosReferencia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPontosReferencia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterSequenciamentoEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterSequenciamentoEvento $parameters
     * @return \StructType\ObterSequenciamentoEventoResponse|bool
     */
    public function obterSequenciamentoEvento(\StructType\ObterSequenciamentoEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterSequenciamentoEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterMensagemPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterMensagemPortal $parameters
     * @return \StructType\ObterMensagemPortalResponse|bool
     */
    public function obterMensagemPortal(\StructType\ObterMensagemPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterMensagemPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterTelemetriaPortal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterTelemetriaPortal $parameters
     * @return \StructType\ObterTelemetriaPortalResponse|bool
     */
    public function obterTelemetriaPortal(\StructType\ObterTelemetriaPortal $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterTelemetriaPortal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterEnderecoPosicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterEnderecoPosicao $parameters
     * @return \StructType\ObterEnderecoPosicaoResponse|bool
     */
    public function obterEnderecoPosicao(\StructType\ObterEnderecoPosicao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterEnderecoPosicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterLayoutAcaoEmbarcadaAVD
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterLayoutAcaoEmbarcadaAVD $parameters
     * @return \StructType\ObterLayoutAcaoEmbarcadaAVDResponse|bool
     */
    public function obterLayoutAcaoEmbarcadaAVD(\StructType\ObterLayoutAcaoEmbarcadaAVD $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterLayoutAcaoEmbarcadaAVD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterEventoTelemetriaDescricao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterEventoTelemetriaDescricao $parameters
     * @return \StructType\ObterEventoTelemetriaDescricaoResponse|bool
     */
    public function obterEventoTelemetriaDescricao(\StructType\ObterEventoTelemetriaDescricao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterEventoTelemetriaDescricao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterEventoTelemetriaIntegracao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterEventoTelemetriaIntegracao $parameters
     * @return \StructType\ObterEventoTelemetriaIntegracaoResponse|bool
     */
    public function obterEventoTelemetriaIntegracao(\StructType\ObterEventoTelemetriaIntegracao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterEventoTelemetriaIntegracao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * obterEventoTelemetriaIntegracaoDataChegada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterEventoTelemetriaIntegracaoDataChegada $parameters
     * @return \StructType\ObterEventoTelemetriaIntegracaoDataChegadaResponse|bool
     */
    public function obterEventoTelemetriaIntegracaoDataChegada(\StructType\ObterEventoTelemetriaIntegracaoDataChegada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterEventoTelemetriaIntegracaoDataChegada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterDeltaTelemetriaIntegracao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterDeltaTelemetriaIntegracao $parameters
     * @return \StructType\ObterDeltaTelemetriaIntegracaoResponse|bool
     */
    public function obterDeltaTelemetriaIntegracao(\StructType\ObterDeltaTelemetriaIntegracao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterDeltaTelemetriaIntegracao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * obterDeltaTelemetriaIntegracaoDataChegada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterDeltaTelemetriaIntegracaoDataChegada $parameters
     * @return \StructType\ObterDeltaTelemetriaIntegracaoDataChegadaResponse|bool
     */
    public function obterDeltaTelemetriaIntegracaoDataChegada(\StructType\ObterDeltaTelemetriaIntegracaoDataChegada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterDeltaTelemetriaIntegracaoDataChegada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterDadosAdicionais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterDadosAdicionais $parameters
     * @return \StructType\ObterDadosAdicionaisResponse|bool
     */
    public function obterDadosAdicionais(\StructType\ObterDadosAdicionais $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterDadosAdicionais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterDadosAdicionaisCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterDadosAdicionaisCliente $parameters
     * @return \StructType\ObterDadosAdicionaisClienteResponse|bool
     */
    public function obterDadosAdicionaisCliente(\StructType\ObterDadosAdicionaisCliente $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterDadosAdicionaisCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterEventosTempoDirecao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterEventosTempoDirecao $parameters
     * @return \StructType\ObterEventosTempoDirecaoResponse|bool
     */
    public function obterEventosTempoDirecao(\StructType\ObterEventosTempoDirecao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterEventosTempoDirecao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * obterEventosTempoDirecaoDataChegada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterEventosTempoDirecaoDataChegada $parameters
     * @return \StructType\ObterEventosTempoDirecaoDataChegadaResponse|bool
     */
    public function obterEventosTempoDirecaoDataChegada(\StructType\ObterEventosTempoDirecaoDataChegada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterEventosTempoDirecaoDataChegada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * obterPacoteIntegracaoDeltatelemetria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterPacoteIntegracaoDeltatelemetria $parameters
     * @return \StructType\ObterPacoteIntegracaoDeltatelemetriaResponse|bool
     */
    public function obterPacoteIntegracaoDeltatelemetria(\StructType\ObterPacoteIntegracaoDeltatelemetria $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterPacoteIntegracaoDeltatelemetria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * obterDeltaTelemetriaIntegracaoInercia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterDeltaTelemetriaIntegracaoInercia $parameters
     * @return \StructType\ObterDeltaTelemetriaIntegracaoInerciaResponse|bool
     */
    public function obterDeltaTelemetriaIntegracaoInercia(\StructType\ObterDeltaTelemetriaIntegracaoInercia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterDeltaTelemetriaIntegracaoInercia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * obterDeltaTelemetriaIntegracaoInerciaDataChegada
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterDeltaTelemetriaIntegracaoInerciaDataChegada $parameters
     * @return \StructType\ObterDeltaTelemetriaIntegracaoInerciaDataChegadaResponse|bool
     */
    public function obterDeltaTelemetriaIntegracaoInerciaDataChegada(\StructType\ObterDeltaTelemetriaIntegracaoInerciaDataChegada $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterDeltaTelemetriaIntegracaoInerciaDataChegada($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterCadastroAlertasAvd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterCadastroAlertasAvd $parameters
     * @return \StructType\ObterCadastroAlertasAvdResponse|bool
     */
    public function obterCadastroAlertasAvd(\StructType\ObterCadastroAlertasAvd $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterCadastroAlertasAvd($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterAlertasAVDVinculados
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterAlertasAVDVinculados $parameters
     * @return \StructType\ObterAlertasAVDVinculadosResponse|bool
     */
    public function obterAlertasAVDVinculados(\StructType\ObterAlertasAVDVinculados $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterAlertasAVDVinculados($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named obterRotas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ObterRotas $parameters
     * @return \StructType\ObterRotasResponse|bool
     */
    public function obterRotas(\StructType\ObterRotas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->obterRotas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ObterAlertasAVDVinculadosResponse|\StructType\ObterCadastroAlertasAvdResponse|\StructType\ObterClientesResponse|\StructType\ObterDadosAdicionaisClienteResponse|\StructType\ObterDadosAdicionaisResponse|\StructType\ObterDeltaTelemetriaIntegracaoDataChegadaResponse|\StructType\ObterDeltaTelemetriaIntegracaoInerciaDataChegadaResponse|\StructType\ObterDeltaTelemetriaIntegracaoInerciaResponse|\StructType\ObterDeltaTelemetriaIntegracaoResponse|\StructType\ObterEnderecoPosicaoResponse|\StructType\ObterEventosTempoDirecaoDataChegadaResponse|\StructType\ObterEventosTempoDirecaoResponse|\StructType\ObterEventoTelemetriaDescricaoResponse|\StructType\ObterEventoTelemetriaIntegracaoDataChegadaResponse|\StructType\ObterEventoTelemetriaIntegracaoResponse|\StructType\ObterGrupoAtuadoresResponse|\StructType\ObterLayoutAcaoEmbarcadaAVDResponse|\StructType\ObterLayoutAreaAvdResponse|\StructType\ObterLayoutDataResponse|\StructType\ObterLayoutDetalhadoResponse|\StructType\ObterLayoutGrupoPontosResponse|\StructType\ObterLayoutResponse|\StructType\ObterLayoutTecladoVeiculosResponse|\StructType\ObterMacroTd40Response|\StructType\ObterMacroTd50TmcdDetalhadoResponse|\StructType\ObterMacroTd50TmcdResponse|\StructType\ObterMacroTms3Response|\StructType\ObterMascaraDispositivosResponse|\StructType\ObterMensagemPortalResponse|\StructType\ObterMotoristasPorVeiculoResponse|\StructType\ObterMotoristasResponse|\StructType\ObterMotoristasVeiculosResponse|\StructType\ObterPacoteIntegracaoDeltatelemetriaResponse|\StructType\ObterPacoteLocalizacaoResponse|\StructType\ObterPacotePosicaoHistoricoResponse|\StructType\ObterPacotePosicaoMotoristaHistoricoResponse|\StructType\ObterPacotePosicaoMotoristaPorRangeJSONResponse|\StructType\ObterPacotePosicaoMotoristaPorRangeResponse|\StructType\ObterPacotePosicaoPorRangeJSONResponse|\StructType\ObterPacotePosicaoPorRangeResponse|\StructType\ObterPacotePosicoesComPlacaResponse|\StructType\ObterPacotePosicoesJSONComPlacaResponse|\StructType\ObterPacotePosicoesJSONResponse|\StructType\ObterPacotePosicoesMotoristaComPlacaResponse|\StructType\ObterPacotePosicoesMotoristaJSONResponse|\StructType\ObterPacotePosicoesMotoristaResponse|\StructType\ObterPacotePosicoesMotoristaRestricaoResponse|\StructType\ObterPacotePosicoesResponse|\StructType\ObterPacotePosicoesRestricaoResponse|\StructType\ObterPacotePosicoesRFNacionalResponse|\StructType\ObterPontosReferenciaResponse|\StructType\ObterRotasResponse|\StructType\ObterSequenciamentoEventoResponse|\StructType\ObterStatusComandoResponse|\StructType\ObterStatusComandoTicketSascarResponse|\StructType\ObterTelemetriaPortalResponse|\StructType\ObterTipoComandoResponse|\StructType\ObterVeiculosJsonResponse|\StructType\ObterVeiculosResponse|\StructType\ObterVeiculosRFNacionalResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
