<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for tipoComando StructType
 * @subpackage Structs
 */
class TipoComando extends AbstractStructBase
{
    /**
     * The descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descricao;
    /**
     * The idTipoComando
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idTipoComando;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nome;
    /**
     * Constructor method for tipoComando
     * @uses TipoComando::setDescricao()
     * @uses TipoComando::setIdTipoComando()
     * @uses TipoComando::setNome()
     * @param string $descricao
     * @param int $idTipoComando
     * @param string $nome
     */
    public function __construct($descricao = null, $idTipoComando = null, $nome = null)
    {
        $this
            ->setDescricao($descricao)
            ->setIdTipoComando($idTipoComando)
            ->setNome($nome);
    }
    /**
     * Get descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\TipoComando
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
    /**
     * Get idTipoComando value
     * @return int|null
     */
    public function getIdTipoComando()
    {
        return $this->idTipoComando;
    }
    /**
     * Set idTipoComando value
     * @param int $idTipoComando
     * @return \StructType\TipoComando
     */
    public function setIdTipoComando($idTipoComando = null)
    {
        // validation for constraint: int
        if (!is_null($idTipoComando) && !(is_int($idTipoComando) || ctype_digit($idTipoComando))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTipoComando, true), gettype($idTipoComando)), __LINE__);
        }
        $this->idTipoComando = $idTipoComando;
        return $this;
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \StructType\TipoComando
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
}
