<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for telemetria StructType
 * @subpackage Structs
 */
class Telemetria extends AbstractStructBase
{
    /**
     * The embreagem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $embreagem;
    /**
     * The estadoLimpadorParabrisa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $estadoLimpadorParabrisa;
    /**
     * The freio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $freio;
    /**
     * The motorFuncionando
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $motorFuncionando;
    /**
     * Constructor method for telemetria
     * @uses Telemetria::setEmbreagem()
     * @uses Telemetria::setEstadoLimpadorParabrisa()
     * @uses Telemetria::setFreio()
     * @uses Telemetria::setMotorFuncionando()
     * @param int $embreagem
     * @param int $estadoLimpadorParabrisa
     * @param int $freio
     * @param int $motorFuncionando
     */
    public function __construct($embreagem = null, $estadoLimpadorParabrisa = null, $freio = null, $motorFuncionando = null)
    {
        $this
            ->setEmbreagem($embreagem)
            ->setEstadoLimpadorParabrisa($estadoLimpadorParabrisa)
            ->setFreio($freio)
            ->setMotorFuncionando($motorFuncionando);
    }
    /**
     * Get embreagem value
     * @return int|null
     */
    public function getEmbreagem()
    {
        return $this->embreagem;
    }
    /**
     * Set embreagem value
     * @param int $embreagem
     * @return \StructType\Telemetria
     */
    public function setEmbreagem($embreagem = null)
    {
        // validation for constraint: int
        if (!is_null($embreagem) && !(is_int($embreagem) || ctype_digit($embreagem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($embreagem, true), gettype($embreagem)), __LINE__);
        }
        $this->embreagem = $embreagem;
        return $this;
    }
    /**
     * Get estadoLimpadorParabrisa value
     * @return int|null
     */
    public function getEstadoLimpadorParabrisa()
    {
        return $this->estadoLimpadorParabrisa;
    }
    /**
     * Set estadoLimpadorParabrisa value
     * @param int $estadoLimpadorParabrisa
     * @return \StructType\Telemetria
     */
    public function setEstadoLimpadorParabrisa($estadoLimpadorParabrisa = null)
    {
        // validation for constraint: int
        if (!is_null($estadoLimpadorParabrisa) && !(is_int($estadoLimpadorParabrisa) || ctype_digit($estadoLimpadorParabrisa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($estadoLimpadorParabrisa, true), gettype($estadoLimpadorParabrisa)), __LINE__);
        }
        $this->estadoLimpadorParabrisa = $estadoLimpadorParabrisa;
        return $this;
    }
    /**
     * Get freio value
     * @return int|null
     */
    public function getFreio()
    {
        return $this->freio;
    }
    /**
     * Set freio value
     * @param int $freio
     * @return \StructType\Telemetria
     */
    public function setFreio($freio = null)
    {
        // validation for constraint: int
        if (!is_null($freio) && !(is_int($freio) || ctype_digit($freio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($freio, true), gettype($freio)), __LINE__);
        }
        $this->freio = $freio;
        return $this;
    }
    /**
     * Get motorFuncionando value
     * @return int|null
     */
    public function getMotorFuncionando()
    {
        return $this->motorFuncionando;
    }
    /**
     * Set motorFuncionando value
     * @param int $motorFuncionando
     * @return \StructType\Telemetria
     */
    public function setMotorFuncionando($motorFuncionando = null)
    {
        // validation for constraint: int
        if (!is_null($motorFuncionando) && !(is_int($motorFuncionando) || ctype_digit($motorFuncionando))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($motorFuncionando, true), gettype($motorFuncionando)), __LINE__);
        }
        $this->motorFuncionando = $motorFuncionando;
        return $this;
    }
}
