<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for smartCamerasEvento StructType
 * @subpackage Structs
 */
class SmartCamerasEvento extends AbstractStructBase
{
    /**
     * The deviceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $deviceId;
    /**
     * The driver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SmartCamerasMotorista
     */
    public $driver;
    /**
     * The eventType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $eventType;
    /**
     * The hwType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $hwType;
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The messageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $messageId;
    /**
     * The ntwkMedium
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ntwkMedium;
    /**
     * The payload
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SmartCamerasPayload
     */
    public $payload;
    /**
     * The pkDeviceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $pkDeviceDate;
    /**
     * The plate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $plate;
    /**
     * The shadow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $shadow;
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timestamp;
    /**
     * Constructor method for smartCamerasEvento
     * @uses SmartCamerasEvento::setDeviceId()
     * @uses SmartCamerasEvento::setDriver()
     * @uses SmartCamerasEvento::setEventType()
     * @uses SmartCamerasEvento::setHwType()
     * @uses SmartCamerasEvento::setId()
     * @uses SmartCamerasEvento::setMessageId()
     * @uses SmartCamerasEvento::setNtwkMedium()
     * @uses SmartCamerasEvento::setPayload()
     * @uses SmartCamerasEvento::setPkDeviceDate()
     * @uses SmartCamerasEvento::setPlate()
     * @uses SmartCamerasEvento::setShadow()
     * @uses SmartCamerasEvento::setTimestamp()
     * @param string $deviceId
     * @param \StructType\SmartCamerasMotorista $driver
     * @param int $eventType
     * @param string $hwType
     * @param string $id
     * @param int $messageId
     * @param string $ntwkMedium
     * @param \StructType\SmartCamerasPayload $payload
     * @param string $pkDeviceDate
     * @param string $plate
     * @param int $shadow
     * @param string $timestamp
     */
    public function __construct($deviceId = null, \StructType\SmartCamerasMotorista $driver = null, $eventType = null, $hwType = null, $id = null, $messageId = null, $ntwkMedium = null, \StructType\SmartCamerasPayload $payload = null, $pkDeviceDate = null, $plate = null, $shadow = null, $timestamp = null)
    {
        $this
            ->setDeviceId($deviceId)
            ->setDriver($driver)
            ->setEventType($eventType)
            ->setHwType($hwType)
            ->setId($id)
            ->setMessageId($messageId)
            ->setNtwkMedium($ntwkMedium)
            ->setPayload($payload)
            ->setPkDeviceDate($pkDeviceDate)
            ->setPlate($plate)
            ->setShadow($shadow)
            ->setTimestamp($timestamp);
    }
    /**
     * Get deviceId value
     * @return string|null
     */
    public function getDeviceId()
    {
        return $this->deviceId;
    }
    /**
     * Set deviceId value
     * @param string $deviceId
     * @return \StructType\SmartCamerasEvento
     */
    public function setDeviceId($deviceId = null)
    {
        // validation for constraint: string
        if (!is_null($deviceId) && !is_string($deviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceId, true), gettype($deviceId)), __LINE__);
        }
        $this->deviceId = $deviceId;
        return $this;
    }
    /**
     * Get driver value
     * @return \StructType\SmartCamerasMotorista|null
     */
    public function getDriver()
    {
        return $this->driver;
    }
    /**
     * Set driver value
     * @param \StructType\SmartCamerasMotorista $driver
     * @return \StructType\SmartCamerasEvento
     */
    public function setDriver(\StructType\SmartCamerasMotorista $driver = null)
    {
        $this->driver = $driver;
        return $this;
    }
    /**
     * Get eventType value
     * @return int|null
     */
    public function getEventType()
    {
        return $this->eventType;
    }
    /**
     * Set eventType value
     * @param int $eventType
     * @return \StructType\SmartCamerasEvento
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: int
        if (!is_null($eventType) && !(is_int($eventType) || ctype_digit($eventType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventType, true), gettype($eventType)), __LINE__);
        }
        $this->eventType = $eventType;
        return $this;
    }
    /**
     * Get hwType value
     * @return string|null
     */
    public function getHwType()
    {
        return $this->hwType;
    }
    /**
     * Set hwType value
     * @param string $hwType
     * @return \StructType\SmartCamerasEvento
     */
    public function setHwType($hwType = null)
    {
        // validation for constraint: string
        if (!is_null($hwType) && !is_string($hwType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hwType, true), gettype($hwType)), __LINE__);
        }
        $this->hwType = $hwType;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\SmartCamerasEvento
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get messageId value
     * @return int|null
     */
    public function getMessageId()
    {
        return $this->messageId;
    }
    /**
     * Set messageId value
     * @param int $messageId
     * @return \StructType\SmartCamerasEvento
     */
    public function setMessageId($messageId = null)
    {
        // validation for constraint: int
        if (!is_null($messageId) && !(is_int($messageId) || ctype_digit($messageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($messageId, true), gettype($messageId)), __LINE__);
        }
        $this->messageId = $messageId;
        return $this;
    }
    /**
     * Get ntwkMedium value
     * @return string|null
     */
    public function getNtwkMedium()
    {
        return $this->ntwkMedium;
    }
    /**
     * Set ntwkMedium value
     * @param string $ntwkMedium
     * @return \StructType\SmartCamerasEvento
     */
    public function setNtwkMedium($ntwkMedium = null)
    {
        // validation for constraint: string
        if (!is_null($ntwkMedium) && !is_string($ntwkMedium)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ntwkMedium, true), gettype($ntwkMedium)), __LINE__);
        }
        $this->ntwkMedium = $ntwkMedium;
        return $this;
    }
    /**
     * Get payload value
     * @return \StructType\SmartCamerasPayload|null
     */
    public function getPayload()
    {
        return $this->payload;
    }
    /**
     * Set payload value
     * @param \StructType\SmartCamerasPayload $payload
     * @return \StructType\SmartCamerasEvento
     */
    public function setPayload(\StructType\SmartCamerasPayload $payload = null)
    {
        $this->payload = $payload;
        return $this;
    }
    /**
     * Get pkDeviceDate value
     * @return string|null
     */
    public function getPkDeviceDate()
    {
        return $this->pkDeviceDate;
    }
    /**
     * Set pkDeviceDate value
     * @param string $pkDeviceDate
     * @return \StructType\SmartCamerasEvento
     */
    public function setPkDeviceDate($pkDeviceDate = null)
    {
        // validation for constraint: string
        if (!is_null($pkDeviceDate) && !is_string($pkDeviceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pkDeviceDate, true), gettype($pkDeviceDate)), __LINE__);
        }
        $this->pkDeviceDate = $pkDeviceDate;
        return $this;
    }
    /**
     * Get plate value
     * @return string|null
     */
    public function getPlate()
    {
        return $this->plate;
    }
    /**
     * Set plate value
     * @param string $plate
     * @return \StructType\SmartCamerasEvento
     */
    public function setPlate($plate = null)
    {
        // validation for constraint: string
        if (!is_null($plate) && !is_string($plate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plate, true), gettype($plate)), __LINE__);
        }
        $this->plate = $plate;
        return $this;
    }
    /**
     * Get shadow value
     * @return int|null
     */
    public function getShadow()
    {
        return $this->shadow;
    }
    /**
     * Set shadow value
     * @param int $shadow
     * @return \StructType\SmartCamerasEvento
     */
    public function setShadow($shadow = null)
    {
        // validation for constraint: int
        if (!is_null($shadow) && !(is_int($shadow) || ctype_digit($shadow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shadow, true), gettype($shadow)), __LINE__);
        }
        $this->shadow = $shadow;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\SmartCamerasEvento
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
}
