<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for obterMotoristas StructType
 * Meta information extracted from the WSDL
 * - type: ns0:obterMotoristas
 * @subpackage Structs
 */
class ObterMotoristas extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senha;
    /**
     * The quantidade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantidade;
    /**
     * The idMotorista
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idMotorista;
    /**
     * Constructor method for obterMotoristas
     * @uses ObterMotoristas::setUsuario()
     * @uses ObterMotoristas::setSenha()
     * @uses ObterMotoristas::setQuantidade()
     * @uses ObterMotoristas::setIdMotorista()
     * @param string $usuario
     * @param string $senha
     * @param int $quantidade
     * @param int $idMotorista
     */
    public function __construct($usuario = null, $senha = null, $quantidade = null, $idMotorista = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setQuantidade($quantidade)
            ->setIdMotorista($idMotorista);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\ObterMotoristas
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->senha;
    }
    /**
     * Set senha value
     * @param string $senha
     * @return \StructType\ObterMotoristas
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->senha = $senha;
        return $this;
    }
    /**
     * Get quantidade value
     * @return int|null
     */
    public function getQuantidade()
    {
        return $this->quantidade;
    }
    /**
     * Set quantidade value
     * @param int $quantidade
     * @return \StructType\ObterMotoristas
     */
    public function setQuantidade($quantidade = null)
    {
        // validation for constraint: int
        if (!is_null($quantidade) && !(is_int($quantidade) || ctype_digit($quantidade))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantidade, true), gettype($quantidade)), __LINE__);
        }
        $this->quantidade = $quantidade;
        return $this;
    }
    /**
     * Get idMotorista value
     * @return int|null
     */
    public function getIdMotorista()
    {
        return $this->idMotorista;
    }
    /**
     * Set idMotorista value
     * @param int $idMotorista
     * @return \StructType\ObterMotoristas
     */
    public function setIdMotorista($idMotorista = null)
    {
        // validation for constraint: int
        if (!is_null($idMotorista) && !(is_int($idMotorista) || ctype_digit($idMotorista))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idMotorista, true), gettype($idMotorista)), __LINE__);
        }
        $this->idMotorista = $idMotorista;
        return $this;
    }
}
