<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for obterMacroTd40 StructType
 * Meta information extracted from the WSDL
 * - type: ns0:obterMacroTd40
 * @subpackage Structs
 */
class ObterMacroTd40 extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senha;
    /**
     * The satelital
     * @var bool
     */
    public $satelital;
    /**
     * Constructor method for obterMacroTd40
     * @uses ObterMacroTd40::setUsuario()
     * @uses ObterMacroTd40::setSenha()
     * @uses ObterMacroTd40::setSatelital()
     * @param string $usuario
     * @param string $senha
     * @param bool $satelital
     */
    public function __construct($usuario = null, $senha = null, $satelital = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setSatelital($satelital);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\ObterMacroTd40
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->senha;
    }
    /**
     * Set senha value
     * @param string $senha
     * @return \StructType\ObterMacroTd40
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->senha = $senha;
        return $this;
    }
    /**
     * Get satelital value
     * @return bool|null
     */
    public function getSatelital()
    {
        return $this->satelital;
    }
    /**
     * Set satelital value
     * @param bool $satelital
     * @return \StructType\ObterMacroTd40
     */
    public function setSatelital($satelital = null)
    {
        // validation for constraint: boolean
        if (!is_null($satelital) && !is_bool($satelital)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($satelital, true), gettype($satelital)), __LINE__);
        }
        $this->satelital = $satelital;
        return $this;
    }
}
