<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for obterLayoutDetalhado StructType
 * Meta information extracted from the WSDL
 * - type: ns0:obterLayoutDetalhado
 * @subpackage Structs
 */
class ObterLayoutDetalhado extends AbstractStructBase
{
    /**
     * The usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $usuario;
    /**
     * The senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $senha;
    /**
     * The layout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $layout;
    /**
     * The idLayout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idLayout;
    /**
     * The dataReferencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataReferencia;
    /**
     * Constructor method for obterLayoutDetalhado
     * @uses ObterLayoutDetalhado::setUsuario()
     * @uses ObterLayoutDetalhado::setSenha()
     * @uses ObterLayoutDetalhado::setLayout()
     * @uses ObterLayoutDetalhado::setIdLayout()
     * @uses ObterLayoutDetalhado::setDataReferencia()
     * @param string $usuario
     * @param string $senha
     * @param string $layout
     * @param int $idLayout
     * @param string $dataReferencia
     */
    public function __construct($usuario = null, $senha = null, $layout = null, $idLayout = null, $dataReferencia = null)
    {
        $this
            ->setUsuario($usuario)
            ->setSenha($senha)
            ->setLayout($layout)
            ->setIdLayout($idLayout)
            ->setDataReferencia($dataReferencia);
    }
    /**
     * Get usuario value
     * @return string|null
     */
    public function getUsuario()
    {
        return $this->usuario;
    }
    /**
     * Set usuario value
     * @param string $usuario
     * @return \StructType\ObterLayoutDetalhado
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        $this->usuario = $usuario;
        return $this;
    }
    /**
     * Get senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->senha;
    }
    /**
     * Set senha value
     * @param string $senha
     * @return \StructType\ObterLayoutDetalhado
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->senha = $senha;
        return $this;
    }
    /**
     * Get layout value
     * @return string|null
     */
    public function getLayout()
    {
        return $this->layout;
    }
    /**
     * Set layout value
     * @uses \EnumType\TipoLayout::valueIsValid()
     * @uses \EnumType\TipoLayout::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $layout
     * @return \StructType\ObterLayoutDetalhado
     */
    public function setLayout($layout = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoLayout::valueIsValid($layout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoLayout', is_array($layout) ? implode(', ', $layout) : var_export($layout, true), implode(', ', \EnumType\TipoLayout::getValidValues())), __LINE__);
        }
        $this->layout = $layout;
        return $this;
    }
    /**
     * Get idLayout value
     * @return int|null
     */
    public function getIdLayout()
    {
        return $this->idLayout;
    }
    /**
     * Set idLayout value
     * @param int $idLayout
     * @return \StructType\ObterLayoutDetalhado
     */
    public function setIdLayout($idLayout = null)
    {
        // validation for constraint: int
        if (!is_null($idLayout) && !(is_int($idLayout) || ctype_digit($idLayout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idLayout, true), gettype($idLayout)), __LINE__);
        }
        $this->idLayout = $idLayout;
        return $this;
    }
    /**
     * Get dataReferencia value
     * @return string|null
     */
    public function getDataReferencia()
    {
        return $this->dataReferencia;
    }
    /**
     * Set dataReferencia value
     * @param string $dataReferencia
     * @return \StructType\ObterLayoutDetalhado
     */
    public function setDataReferencia($dataReferencia = null)
    {
        // validation for constraint: string
        if (!is_null($dataReferencia) && !is_string($dataReferencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataReferencia, true), gettype($dataReferencia)), __LINE__);
        }
        $this->dataReferencia = $dataReferencia;
        return $this;
    }
}
