<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mensagem StructType
 * @subpackage Structs
 */
class Mensagem extends AbstractStructBase
{
    /**
     * The mensagem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mensagem;
    /**
     * Constructor method for mensagem
     * @uses Mensagem::setMensagem()
     * @param string $mensagem
     */
    public function __construct($mensagem = null)
    {
        $this
            ->setMensagem($mensagem);
    }
    /**
     * Get mensagem value
     * @return string|null
     */
    public function getMensagem()
    {
        return $this->mensagem;
    }
    /**
     * Set mensagem value
     * @param string $mensagem
     * @return \StructType\Mensagem
     */
    public function setMensagem($mensagem = null)
    {
        // validation for constraint: string
        if (!is_null($mensagem) && !is_string($mensagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensagem, true), gettype($mensagem)), __LINE__);
        }
        $this->mensagem = $mensagem;
        return $this;
    }
}
