<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for layout StructType
 * @subpackage Structs
 */
class Layout extends AbstractStructBase
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $codigo;
    /**
     * The dataAlteracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataAlteracao;
    /**
     * The dataCriacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataCriacao;
    /**
     * The descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descricao;
    /**
     * The idLayout
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idLayout;
    /**
     * The tipoTeclado
     * @var int
     */
    public $tipoTeclado;
    /**
     * Constructor method for layout
     * @uses Layout::setCodigo()
     * @uses Layout::setDataAlteracao()
     * @uses Layout::setDataCriacao()
     * @uses Layout::setDescricao()
     * @uses Layout::setIdLayout()
     * @uses Layout::setTipoTeclado()
     * @param int $codigo
     * @param string $dataAlteracao
     * @param string $dataCriacao
     * @param string $descricao
     * @param int $idLayout
     * @param int $tipoTeclado
     */
    public function __construct($codigo = null, $dataAlteracao = null, $dataCriacao = null, $descricao = null, $idLayout = null, $tipoTeclado = null)
    {
        $this
            ->setCodigo($codigo)
            ->setDataAlteracao($dataAlteracao)
            ->setDataCriacao($dataCriacao)
            ->setDescricao($descricao)
            ->setIdLayout($idLayout)
            ->setTipoTeclado($tipoTeclado);
    }
    /**
     * Get codigo value
     * @return int|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param int $codigo
     * @return \StructType\Layout
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: int
        if (!is_null($codigo) && !(is_int($codigo) || ctype_digit($codigo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get dataAlteracao value
     * @return string|null
     */
    public function getDataAlteracao()
    {
        return $this->dataAlteracao;
    }
    /**
     * Set dataAlteracao value
     * @param string $dataAlteracao
     * @return \StructType\Layout
     */
    public function setDataAlteracao($dataAlteracao = null)
    {
        // validation for constraint: string
        if (!is_null($dataAlteracao) && !is_string($dataAlteracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAlteracao, true), gettype($dataAlteracao)), __LINE__);
        }
        $this->dataAlteracao = $dataAlteracao;
        return $this;
    }
    /**
     * Get dataCriacao value
     * @return string|null
     */
    public function getDataCriacao()
    {
        return $this->dataCriacao;
    }
    /**
     * Set dataCriacao value
     * @param string $dataCriacao
     * @return \StructType\Layout
     */
    public function setDataCriacao($dataCriacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataCriacao) && !is_string($dataCriacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataCriacao, true), gettype($dataCriacao)), __LINE__);
        }
        $this->dataCriacao = $dataCriacao;
        return $this;
    }
    /**
     * Get descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\Layout
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
    /**
     * Get idLayout value
     * @return int|null
     */
    public function getIdLayout()
    {
        return $this->idLayout;
    }
    /**
     * Set idLayout value
     * @param int $idLayout
     * @return \StructType\Layout
     */
    public function setIdLayout($idLayout = null)
    {
        // validation for constraint: int
        if (!is_null($idLayout) && !(is_int($idLayout) || ctype_digit($idLayout))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idLayout, true), gettype($idLayout)), __LINE__);
        }
        $this->idLayout = $idLayout;
        return $this;
    }
    /**
     * Get tipoTeclado value
     * @return int|null
     */
    public function getTipoTeclado()
    {
        return $this->tipoTeclado;
    }
    /**
     * Set tipoTeclado value
     * @param int $tipoTeclado
     * @return \StructType\Layout
     */
    public function setTipoTeclado($tipoTeclado = null)
    {
        // validation for constraint: int
        if (!is_null($tipoTeclado) && !(is_int($tipoTeclado) || ctype_digit($tipoTeclado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tipoTeclado, true), gettype($tipoTeclado)), __LINE__);
        }
        $this->tipoTeclado = $tipoTeclado;
        return $this;
    }
}
