<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getVehiclesJSON StructType
 * Meta information extracted from the WSDL
 * - type: ns0:getVehiclesJSON
 * @subpackage Structs
 */
class GetVehiclesJSON extends AbstractStructBase
{
    /**
     * The user
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $user;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The vehicleId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $vehicleId;
    /**
     * Constructor method for getVehiclesJSON
     * @uses GetVehiclesJSON::setUser()
     * @uses GetVehiclesJSON::setPassword()
     * @uses GetVehiclesJSON::setQuantity()
     * @uses GetVehiclesJSON::setVehicleId()
     * @param string $user
     * @param string $password
     * @param int $quantity
     * @param int $vehicleId
     */
    public function __construct($user = null, $password = null, $quantity = null, $vehicleId = null)
    {
        $this
            ->setUser($user)
            ->setPassword($password)
            ->setQuantity($quantity)
            ->setVehicleId($vehicleId);
    }
    /**
     * Get user value
     * @return string|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @param string $user
     * @return \StructType\GetVehiclesJSON
     */
    public function setUser($user = null)
    {
        // validation for constraint: string
        if (!is_null($user) && !is_string($user)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($user, true), gettype($user)), __LINE__);
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetVehiclesJSON
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\GetVehiclesJSON
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get vehicleId value
     * @return int|null
     */
    public function getVehicleId()
    {
        return $this->vehicleId;
    }
    /**
     * Set vehicleId value
     * @param int $vehicleId
     * @return \StructType\GetVehiclesJSON
     */
    public function setVehicleId($vehicleId = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleId) && !(is_int($vehicleId) || ctype_digit($vehicleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vehicleId, true), gettype($vehicleId)), __LINE__);
        }
        $this->vehicleId = $vehicleId;
        return $this;
    }
}
