<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for endereco StructType
 * @subpackage Structs
 */
class Endereco extends AbstractStructBase
{
    /**
     * The city
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Cidade
     */
    public $city;
    /**
     * The street
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $street;
    /**
     * Constructor method for endereco
     * @uses Endereco::setCity()
     * @uses Endereco::setStreet()
     * @param \StructType\Cidade $city
     * @param string $street
     */
    public function __construct(\StructType\Cidade $city = null, $street = null)
    {
        $this
            ->setCity($city)
            ->setStreet($street);
    }
    /**
     * Get city value
     * @return \StructType\Cidade|null
     */
    public function getCity()
    {
        return $this->city;
    }
    /**
     * Set city value
     * @param \StructType\Cidade $city
     * @return \StructType\Endereco
     */
    public function setCity(\StructType\Cidade $city = null)
    {
        $this->city = $city;
        return $this;
    }
    /**
     * Get street value
     * @return string|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @param string $street
     * @return \StructType\Endereco
     */
    public function setStreet($street = null)
    {
        // validation for constraint: string
        if (!is_null($street) && !is_string($street)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($street, true), gettype($street)), __LINE__);
        }
        $this->street = $street;
        return $this;
    }
}
