<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cliente StructType
 * @subpackage Structs
 */
class Cliente extends AbstractStructBase
{
    /**
     * The cnpj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cnpj;
    /**
     * The cpf
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $cpf;
    /**
     * The idCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $idCliente;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nome;
    /**
     * Constructor method for cliente
     * @uses Cliente::setCnpj()
     * @uses Cliente::setCpf()
     * @uses Cliente::setIdCliente()
     * @uses Cliente::setNome()
     * @param int $cnpj
     * @param int $cpf
     * @param int $idCliente
     * @param string $nome
     */
    public function __construct($cnpj = null, $cpf = null, $idCliente = null, $nome = null)
    {
        $this
            ->setCnpj($cnpj)
            ->setCpf($cpf)
            ->setIdCliente($idCliente)
            ->setNome($nome);
    }
    /**
     * Get cnpj value
     * @return int|null
     */
    public function getCnpj()
    {
        return $this->cnpj;
    }
    /**
     * Set cnpj value
     * @param int $cnpj
     * @return \StructType\Cliente
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: int
        if (!is_null($cnpj) && !(is_int($cnpj) || ctype_digit($cnpj))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cnpj, true), gettype($cnpj)), __LINE__);
        }
        $this->cnpj = $cnpj;
        return $this;
    }
    /**
     * Get cpf value
     * @return int|null
     */
    public function getCpf()
    {
        return $this->cpf;
    }
    /**
     * Set cpf value
     * @param int $cpf
     * @return \StructType\Cliente
     */
    public function setCpf($cpf = null)
    {
        // validation for constraint: int
        if (!is_null($cpf) && !(is_int($cpf) || ctype_digit($cpf))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cpf, true), gettype($cpf)), __LINE__);
        }
        $this->cpf = $cpf;
        return $this;
    }
    /**
     * Get idCliente value
     * @return int|null
     */
    public function getIdCliente()
    {
        return $this->idCliente;
    }
    /**
     * Set idCliente value
     * @param int $idCliente
     * @return \StructType\Cliente
     */
    public function setIdCliente($idCliente = null)
    {
        // validation for constraint: int
        if (!is_null($idCliente) && !(is_int($idCliente) || ctype_digit($idCliente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCliente, true), gettype($idCliente)), __LINE__);
        }
        $this->idCliente = $idCliente;
        return $this;
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \StructType\Cliente
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
}
