<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Solicitar ServiceType
 * @subpackage Services
 */
class Solicitar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named solicitarEventosCaixaPreta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SolicitarEventosCaixaPreta $parameters
     * @return \StructType\SolicitarEventosCaixaPretaResponse|bool
     */
    public function solicitarEventosCaixaPreta(\StructType\SolicitarEventosCaixaPreta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->solicitarEventosCaixaPreta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SolicitarEventosCaixaPretaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
