<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Recuperar ServiceType
 * @subpackage Services
 */
class Recuperar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named recuperarEventosCaixaPreta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RecuperarEventosCaixaPreta $parameters
     * @return \StructType\RecuperarEventosCaixaPretaResponse|bool
     */
    public function recuperarEventosCaixaPreta(\StructType\RecuperarEventosCaixaPreta $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->recuperarEventosCaixaPreta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RecuperarEventosCaixaPretaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
