<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Enviar ServiceType
 * @subpackage Services
 */
class Enviar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named enviarParametrizacaoTelemetria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EnviarParametrizacaoTelemetria $parameters
     * @return \StructType\EnviarParametrizacaoTelemetriaResponse|bool
     */
    public function enviarParametrizacaoTelemetria(\StructType\EnviarParametrizacaoTelemetria $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->enviarParametrizacaoTelemetria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EnviarParametrizacaoTelemetriaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
