<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Comando ServiceType
 * @subpackage Services
 */
class Comando extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named comandoEmbarquePontoDiario
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ComandoEmbarquePontoDiario $parameters
     * @return \StructType\ComandoEmbarquePontoDiarioResponse|bool
     */
    public function comandoEmbarquePontoDiario(\StructType\ComandoEmbarquePontoDiario $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->comandoEmbarquePontoDiario($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ComandoEmbarquePontoDiarioResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
