<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Atualizar ServiceType
 * @subpackage Services
 */
class Atualizar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named atualizarSenha
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizarSenha $parameters
     * @return \StructType\AtualizarSenhaResponse|bool
     */
    public function atualizarSenha(\StructType\AtualizarSenha $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->atualizarSenha($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AtualizarSenhaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
