<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TCKimlikNoDogrula StructType
 * @subpackage Structs
 */
class TCKimlikNoDogrula extends AbstractStructBase
{
    /**
     * The TCKimlikNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TCKimlikNo;
    /**
     * The DogumYili
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $DogumYili;
    /**
     * The Ad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ad;
    /**
     * The Soyad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Soyad;
    /**
     * Constructor method for TCKimlikNoDogrula
     * @uses TCKimlikNoDogrula::setTCKimlikNo()
     * @uses TCKimlikNoDogrula::setDogumYili()
     * @uses TCKimlikNoDogrula::setAd()
     * @uses TCKimlikNoDogrula::setSoyad()
     * @param int $tCKimlikNo
     * @param int $dogumYili
     * @param string $ad
     * @param string $soyad
     */
    public function __construct($tCKimlikNo = null, $dogumYili = null, $ad = null, $soyad = null)
    {
        $this
            ->setTCKimlikNo($tCKimlikNo)
            ->setDogumYili($dogumYili)
            ->setAd($ad)
            ->setSoyad($soyad);
    }
    /**
     * Get TCKimlikNo value
     * @return int
     */
    public function getTCKimlikNo()
    {
        return $this->TCKimlikNo;
    }
    /**
     * Set TCKimlikNo value
     * @param int $tCKimlikNo
     * @return \StructType\TCKimlikNoDogrula
     */
    public function setTCKimlikNo($tCKimlikNo = null)
    {
        // validation for constraint: int
        if (!is_null($tCKimlikNo) && !(is_int($tCKimlikNo) || ctype_digit($tCKimlikNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tCKimlikNo, true), gettype($tCKimlikNo)), __LINE__);
        }
        $this->TCKimlikNo = $tCKimlikNo;
        return $this;
    }
    /**
     * Get DogumYili value
     * @return int
     */
    public function getDogumYili()
    {
        return $this->DogumYili;
    }
    /**
     * Set DogumYili value
     * @param int $dogumYili
     * @return \StructType\TCKimlikNoDogrula
     */
    public function setDogumYili($dogumYili = null)
    {
        // validation for constraint: int
        if (!is_null($dogumYili) && !(is_int($dogumYili) || ctype_digit($dogumYili))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dogumYili, true), gettype($dogumYili)), __LINE__);
        }
        $this->DogumYili = $dogumYili;
        return $this;
    }
    /**
     * Get Ad value
     * @return string|null
     */
    public function getAd()
    {
        return $this->Ad;
    }
    /**
     * Set Ad value
     * @param string $ad
     * @return \StructType\TCKimlikNoDogrula
     */
    public function setAd($ad = null)
    {
        // validation for constraint: string
        if (!is_null($ad) && !is_string($ad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad, true), gettype($ad)), __LINE__);
        }
        $this->Ad = $ad;
        return $this;
    }
    /**
     * Get Soyad value
     * @return string|null
     */
    public function getSoyad()
    {
        return $this->Soyad;
    }
    /**
     * Set Soyad value
     * @param string $soyad
     * @return \StructType\TCKimlikNoDogrula
     */
    public function setSoyad($soyad = null)
    {
        // validation for constraint: string
        if (!is_null($soyad) && !is_string($soyad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($soyad, true), gettype($soyad)), __LINE__);
        }
        $this->Soyad = $soyad;
        return $this;
    }
}
