<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for TCK ServiceType
 * @subpackage Services
 */
class TCK extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TCKimlikNoDogrula
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TCKimlikNoDogrula $parameters
     * @return \StructType\TCKimlikNoDogrulaResponse|bool
     */
    public function TCKimlikNoDogrula(\StructType\TCKimlikNoDogrula $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TCKimlikNoDogrula($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TCKimlikNoDogrulaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
