<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PoslednaZmenaNaKonani StructType
 * @subpackage Structs
 */
class PoslednaZmenaNaKonani extends AbstractStructBase
{
    /**
     * The KonanieId
     * @var string
     */
    public $KonanieId;
    /**
     * The PoslednaZmena
     * @var string
     */
    public $PoslednaZmena;
    /**
     * Constructor method for PoslednaZmenaNaKonani
     * @uses PoslednaZmenaNaKonani::setKonanieId()
     * @uses PoslednaZmenaNaKonani::setPoslednaZmena()
     * @param string $konanieId
     * @param string $poslednaZmena
     */
    public function __construct($konanieId = null, $poslednaZmena = null)
    {
        $this
            ->setKonanieId($konanieId)
            ->setPoslednaZmena($poslednaZmena);
    }
    /**
     * Get KonanieId value
     * @return string|null
     */
    public function getKonanieId()
    {
        return $this->KonanieId;
    }
    /**
     * Set KonanieId value
     * @param string $konanieId
     * @return \StructType\PoslednaZmenaNaKonani
     */
    public function setKonanieId($konanieId = null)
    {
        // validation for constraint: string
        if (!is_null($konanieId) && !is_string($konanieId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($konanieId, true), gettype($konanieId)), __LINE__);
        }
        $this->KonanieId = $konanieId;
        return $this;
    }
    /**
     * Get PoslednaZmena value
     * @return string|null
     */
    public function getPoslednaZmena()
    {
        return $this->PoslednaZmena;
    }
    /**
     * Set PoslednaZmena value
     * @param string $poslednaZmena
     * @return \StructType\PoslednaZmenaNaKonani
     */
    public function setPoslednaZmena($poslednaZmena = null)
    {
        // validation for constraint: string
        if (!is_null($poslednaZmena) && !is_string($poslednaZmena)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poslednaZmena, true), gettype($poslednaZmena)), __LINE__);
        }
        $this->PoslednaZmena = $poslednaZmena;
        return $this;
    }
}
