<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getKonaniePodlaICORequest StructType
 * @subpackage Structs
 */
class GetKonaniePodlaICORequest extends AbstractStructBase
{
    /**
     * The Ico
     * @var string
     */
    public $Ico;
    /**
     * The Stranka
     * Meta information extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var int
     */
    public $Stranka;
    /**
     * The VysledkovNaStranku
     * Meta information extracted from the WSDL
     * - default: 10
     * - minOccurs: 0
     * @var int
     */
    public $VysledkovNaStranku;
    /**
     * The TypTriedenia
     * Meta information extracted from the WSDL
     * - default: DatumPoslednejUdalosti
     * - minOccurs: 0
     * @var string
     */
    public $TypTriedenia;
    /**
     * Constructor method for getKonaniePodlaICORequest
     * @uses GetKonaniePodlaICORequest::setIco()
     * @uses GetKonaniePodlaICORequest::setStranka()
     * @uses GetKonaniePodlaICORequest::setVysledkovNaStranku()
     * @uses GetKonaniePodlaICORequest::setTypTriedenia()
     * @param string $ico
     * @param int $stranka
     * @param int $vysledkovNaStranku
     * @param string $typTriedenia
     */
    public function __construct($ico = null, $stranka = 0, $vysledkovNaStranku = 10, $typTriedenia = 'DatumPoslednejUdalosti')
    {
        $this
            ->setIco($ico)
            ->setStranka($stranka)
            ->setVysledkovNaStranku($vysledkovNaStranku)
            ->setTypTriedenia($typTriedenia);
    }
    /**
     * Get Ico value
     * @return string|null
     */
    public function getIco()
    {
        return $this->Ico;
    }
    /**
     * Set Ico value
     * @param string $ico
     * @return \StructType\GetKonaniePodlaICORequest
     */
    public function setIco($ico = null)
    {
        // validation for constraint: string
        if (!is_null($ico) && !is_string($ico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ico, true), gettype($ico)), __LINE__);
        }
        $this->Ico = $ico;
        return $this;
    }
    /**
     * Get Stranka value
     * @return int|null
     */
    public function getStranka()
    {
        return $this->Stranka;
    }
    /**
     * Set Stranka value
     * @param int $stranka
     * @return \StructType\GetKonaniePodlaICORequest
     */
    public function setStranka($stranka = 0)
    {
        // validation for constraint: int
        if (!is_null($stranka) && !(is_int($stranka) || ctype_digit($stranka))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stranka, true), gettype($stranka)), __LINE__);
        }
        $this->Stranka = $stranka;
        return $this;
    }
    /**
     * Get VysledkovNaStranku value
     * @return int|null
     */
    public function getVysledkovNaStranku()
    {
        return $this->VysledkovNaStranku;
    }
    /**
     * Set VysledkovNaStranku value
     * @param int $vysledkovNaStranku
     * @return \StructType\GetKonaniePodlaICORequest
     */
    public function setVysledkovNaStranku($vysledkovNaStranku = 10)
    {
        // validation for constraint: int
        if (!is_null($vysledkovNaStranku) && !(is_int($vysledkovNaStranku) || ctype_digit($vysledkovNaStranku))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vysledkovNaStranku, true), gettype($vysledkovNaStranku)), __LINE__);
        }
        $this->VysledkovNaStranku = $vysledkovNaStranku;
        return $this;
    }
    /**
     * Get TypTriedenia value
     * @return string|null
     */
    public function getTypTriedenia()
    {
        return $this->TypTriedenia;
    }
    /**
     * Set TypTriedenia value
     * @uses \EnumType\TypTriedenia::valueIsValid()
     * @uses \EnumType\TypTriedenia::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typTriedenia
     * @return \StructType\GetKonaniePodlaICORequest
     */
    public function setTypTriedenia($typTriedenia = 'DatumPoslednejUdalosti')
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypTriedenia::valueIsValid($typTriedenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypTriedenia', is_array($typTriedenia) ? implode(', ', $typTriedenia) : var_export($typTriedenia, true), implode(', ', \EnumType\TypTriedenia::getValidValues())), __LINE__);
        }
        $this->TypTriedenia = $typTriedenia;
        return $this;
    }
}
