<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankovyUcet StructType
 * @subpackage Structs
 */
class BankovyUcet extends AbstractStructBase
{
    /**
     * The Iban
     * @var string
     */
    public $Iban;
    /**
     * The Swift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Swift;
    /**
     * Constructor method for BankovyUcet
     * @uses BankovyUcet::setIban()
     * @uses BankovyUcet::setSwift()
     * @param string $iban
     * @param string $swift
     */
    public function __construct($iban = null, $swift = null)
    {
        $this
            ->setIban($iban)
            ->setSwift($swift);
    }
    /**
     * Get Iban value
     * @return string|null
     */
    public function getIban()
    {
        return $this->Iban;
    }
    /**
     * Set Iban value
     * @param string $iban
     * @return \StructType\BankovyUcet
     */
    public function setIban($iban = null)
    {
        // validation for constraint: string
        if (!is_null($iban) && !is_string($iban)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iban, true), gettype($iban)), __LINE__);
        }
        $this->Iban = $iban;
        return $this;
    }
    /**
     * Get Swift value
     * @return string|null
     */
    public function getSwift()
    {
        return $this->Swift;
    }
    /**
     * Set Swift value
     * @param string $swift
     * @return \StructType\BankovyUcet
     */
    public function setSwift($swift = null)
    {
        // validation for constraint: string
        if (!is_null($swift) && !is_string($swift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($swift, true), gettype($swift)), __LINE__);
        }
        $this->Swift = $swift;
        return $this;
    }
}
