<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Vyhladaj ServiceType
 * @subpackage Services
 */
class Vyhladaj extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named vyhladajKonanie
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VyhladajKonanieRequest $vyhladajKonanieRequest
     * @return \StructType\VyhladajKonanieResponse|bool
     */
    public function vyhladajKonanie(\StructType\VyhladajKonanieRequest $vyhladajKonanieRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->vyhladajKonanie($vyhladajKonanieRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named vyhladajPoslednuZmenuOd
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\VyhladajPoslednuZmenuOdRequest $vyhladajPoslednuZmenuOdRequest
     * @return \StructType\VyhladajPoslednuZmenuOdResponse|bool
     */
    public function vyhladajPoslednuZmenuOd(\StructType\VyhladajPoslednuZmenuOdRequest $vyhladajPoslednuZmenuOdRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->vyhladajPoslednuZmenuOd($vyhladajPoslednuZmenuOdRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\VyhladajKonanieResponse|\StructType\VyhladajPoslednuZmenuOdResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
