<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PravnickaOsoba StructType
 * @subpackage Structs
 */
class PravnickaOsoba extends Osoba
{
    /**
     * The ObchodneMeno
     * @var string
     */
    public $ObchodneMeno;
    /**
     * The Ico
     * @var string
     */
    public $Ico;
    /**
     * The PravnaForma
     * @var string
     */
    public $PravnaForma;
    /**
     * The Register
     * @var string
     */
    public $Register;
    /**
     * The CisloRegistracie
     * @var string
     */
    public $CisloRegistracie;
    /**
     * Constructor method for PravnickaOsoba
     * @uses PravnickaOsoba::setObchodneMeno()
     * @uses PravnickaOsoba::setIco()
     * @uses PravnickaOsoba::setPravnaForma()
     * @uses PravnickaOsoba::setRegister()
     * @uses PravnickaOsoba::setCisloRegistracie()
     * @param string $obchodneMeno
     * @param string $ico
     * @param string $pravnaForma
     * @param string $register
     * @param string $cisloRegistracie
     */
    public function __construct($obchodneMeno = null, $ico = null, $pravnaForma = null, $register = null, $cisloRegistracie = null)
    {
        $this
            ->setObchodneMeno($obchodneMeno)
            ->setIco($ico)
            ->setPravnaForma($pravnaForma)
            ->setRegister($register)
            ->setCisloRegistracie($cisloRegistracie);
    }
    /**
     * Get ObchodneMeno value
     * @return string|null
     */
    public function getObchodneMeno()
    {
        return $this->ObchodneMeno;
    }
    /**
     * Set ObchodneMeno value
     * @param string $obchodneMeno
     * @return \StructType\PravnickaOsoba
     */
    public function setObchodneMeno($obchodneMeno = null)
    {
        // validation for constraint: string
        if (!is_null($obchodneMeno) && !is_string($obchodneMeno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obchodneMeno, true), gettype($obchodneMeno)), __LINE__);
        }
        $this->ObchodneMeno = $obchodneMeno;
        return $this;
    }
    /**
     * Get Ico value
     * @return string|null
     */
    public function getIco()
    {
        return $this->Ico;
    }
    /**
     * Set Ico value
     * @param string $ico
     * @return \StructType\PravnickaOsoba
     */
    public function setIco($ico = null)
    {
        // validation for constraint: string
        if (!is_null($ico) && !is_string($ico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ico, true), gettype($ico)), __LINE__);
        }
        $this->Ico = $ico;
        return $this;
    }
    /**
     * Get PravnaForma value
     * @return string|null
     */
    public function getPravnaForma()
    {
        return $this->PravnaForma;
    }
    /**
     * Set PravnaForma value
     * @param string $pravnaForma
     * @return \StructType\PravnickaOsoba
     */
    public function setPravnaForma($pravnaForma = null)
    {
        // validation for constraint: string
        if (!is_null($pravnaForma) && !is_string($pravnaForma)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pravnaForma, true), gettype($pravnaForma)), __LINE__);
        }
        $this->PravnaForma = $pravnaForma;
        return $this;
    }
    /**
     * Get Register value
     * @return string|null
     */
    public function getRegister()
    {
        return $this->Register;
    }
    /**
     * Set Register value
     * @param string $register
     * @return \StructType\PravnickaOsoba
     */
    public function setRegister($register = null)
    {
        // validation for constraint: string
        if (!is_null($register) && !is_string($register)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($register, true), gettype($register)), __LINE__);
        }
        $this->Register = $register;
        return $this;
    }
    /**
     * Get CisloRegistracie value
     * @return string|null
     */
    public function getCisloRegistracie()
    {
        return $this->CisloRegistracie;
    }
    /**
     * Set CisloRegistracie value
     * @param string $cisloRegistracie
     * @return \StructType\PravnickaOsoba
     */
    public function setCisloRegistracie($cisloRegistracie = null)
    {
        // validation for constraint: string
        if (!is_null($cisloRegistracie) && !is_string($cisloRegistracie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cisloRegistracie, true), gettype($cisloRegistracie)), __LINE__);
        }
        $this->CisloRegistracie = $cisloRegistracie;
        return $this;
    }
}
