<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Konanie StructType
 * @subpackage Structs
 */
class Konanie extends AbstractStructBase
{
    /**
     * The Id
     * @var int
     */
    public $Id;
    /**
     * The SpisovaZnackaSpravcu
     * @var string
     */
    public $SpisovaZnackaSpravcu;
    /**
     * The SpisovaZnackaSudu
     * @var string
     */
    public $SpisovaZnackaSudu;
    /**
     * The Typ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Typ;
    /**
     * The Navrhovatel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Osoba[]
     */
    public $Navrhovatel;
    /**
     * The Dlznik
     * @var \StructType\Osoba
     */
    public $Dlznik;
    /**
     * The Sud
     * @var \StructType\Sud
     */
    public $Sud;
    /**
     * The Sudca
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Sudca;
    /**
     * The Spravca
     * @var \StructType\Spravca
     */
    public $Spravca;
    /**
     * The DatumZacatiaKonania
     * @var string
     */
    public $DatumZacatiaKonania;
    /**
     * The DatumZacatiaProcesu
     * @var string
     */
    public $DatumZacatiaProcesu;
    /**
     * The TypSpravcu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TypSpravcu;
    /**
     * The TypPrideleniaSpravcu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TypPrideleniaSpravcu;
    /**
     * The TypKonaniaPodlaUzemnejPlatnosti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TypKonaniaPodlaUzemnejPlatnosti;
    /**
     * Constructor method for Konanie
     * @uses Konanie::setId()
     * @uses Konanie::setSpisovaZnackaSpravcu()
     * @uses Konanie::setSpisovaZnackaSudu()
     * @uses Konanie::setTyp()
     * @uses Konanie::setNavrhovatel()
     * @uses Konanie::setDlznik()
     * @uses Konanie::setSud()
     * @uses Konanie::setSudca()
     * @uses Konanie::setSpravca()
     * @uses Konanie::setDatumZacatiaKonania()
     * @uses Konanie::setDatumZacatiaProcesu()
     * @uses Konanie::setTypSpravcu()
     * @uses Konanie::setTypPrideleniaSpravcu()
     * @uses Konanie::setTypKonaniaPodlaUzemnejPlatnosti()
     * @param int $id
     * @param string $spisovaZnackaSpravcu
     * @param string $spisovaZnackaSudu
     * @param string $typ
     * @param \StructType\Osoba[] $navrhovatel
     * @param \StructType\Osoba $dlznik
     * @param \StructType\Sud $sud
     * @param string $sudca
     * @param \StructType\Spravca $spravca
     * @param string $datumZacatiaKonania
     * @param string $datumZacatiaProcesu
     * @param string $typSpravcu
     * @param string $typPrideleniaSpravcu
     * @param string $typKonaniaPodlaUzemnejPlatnosti
     */
    public function __construct($id = null, $spisovaZnackaSpravcu = null, $spisovaZnackaSudu = null, $typ = null, array $navrhovatel = array(), \StructType\Osoba $dlznik = null, \StructType\Sud $sud = null, $sudca = null, \StructType\Spravca $spravca = null, $datumZacatiaKonania = null, $datumZacatiaProcesu = null, $typSpravcu = null, $typPrideleniaSpravcu = null, $typKonaniaPodlaUzemnejPlatnosti = null)
    {
        $this
            ->setId($id)
            ->setSpisovaZnackaSpravcu($spisovaZnackaSpravcu)
            ->setSpisovaZnackaSudu($spisovaZnackaSudu)
            ->setTyp($typ)
            ->setNavrhovatel($navrhovatel)
            ->setDlznik($dlznik)
            ->setSud($sud)
            ->setSudca($sudca)
            ->setSpravca($spravca)
            ->setDatumZacatiaKonania($datumZacatiaKonania)
            ->setDatumZacatiaProcesu($datumZacatiaProcesu)
            ->setTypSpravcu($typSpravcu)
            ->setTypPrideleniaSpravcu($typPrideleniaSpravcu)
            ->setTypKonaniaPodlaUzemnejPlatnosti($typKonaniaPodlaUzemnejPlatnosti);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\Konanie
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get SpisovaZnackaSpravcu value
     * @return string|null
     */
    public function getSpisovaZnackaSpravcu()
    {
        return $this->SpisovaZnackaSpravcu;
    }
    /**
     * Set SpisovaZnackaSpravcu value
     * @param string $spisovaZnackaSpravcu
     * @return \StructType\Konanie
     */
    public function setSpisovaZnackaSpravcu($spisovaZnackaSpravcu = null)
    {
        // validation for constraint: string
        if (!is_null($spisovaZnackaSpravcu) && !is_string($spisovaZnackaSpravcu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spisovaZnackaSpravcu, true), gettype($spisovaZnackaSpravcu)), __LINE__);
        }
        $this->SpisovaZnackaSpravcu = $spisovaZnackaSpravcu;
        return $this;
    }
    /**
     * Get SpisovaZnackaSudu value
     * @return string|null
     */
    public function getSpisovaZnackaSudu()
    {
        return $this->SpisovaZnackaSudu;
    }
    /**
     * Set SpisovaZnackaSudu value
     * @param string $spisovaZnackaSudu
     * @return \StructType\Konanie
     */
    public function setSpisovaZnackaSudu($spisovaZnackaSudu = null)
    {
        // validation for constraint: string
        if (!is_null($spisovaZnackaSudu) && !is_string($spisovaZnackaSudu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spisovaZnackaSudu, true), gettype($spisovaZnackaSudu)), __LINE__);
        }
        $this->SpisovaZnackaSudu = $spisovaZnackaSudu;
        return $this;
    }
    /**
     * Get Typ value
     * @return string|null
     */
    public function getTyp()
    {
        return $this->Typ;
    }
    /**
     * Set Typ value
     * @uses \EnumType\KonanieTyp::valueIsValid()
     * @uses \EnumType\KonanieTyp::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typ
     * @return \StructType\Konanie
     */
    public function setTyp($typ = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KonanieTyp::valueIsValid($typ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KonanieTyp', is_array($typ) ? implode(', ', $typ) : var_export($typ, true), implode(', ', \EnumType\KonanieTyp::getValidValues())), __LINE__);
        }
        $this->Typ = $typ;
        return $this;
    }
    /**
     * Get Navrhovatel value
     * @return \StructType\Osoba[]|null
     */
    public function getNavrhovatel()
    {
        return $this->Navrhovatel;
    }
    /**
     * This method is responsible for validating the values passed to the setNavrhovatel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNavrhovatel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNavrhovatelForArrayConstraintsFromSetNavrhovatel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $konanieNavrhovatelItem) {
            // validation for constraint: itemType
            if (!$konanieNavrhovatelItem instanceof \StructType\Osoba) {
                $invalidValues[] = is_object($konanieNavrhovatelItem) ? get_class($konanieNavrhovatelItem) : sprintf('%s(%s)', gettype($konanieNavrhovatelItem), var_export($konanieNavrhovatelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Navrhovatel property can only contain items of type \StructType\Osoba, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Navrhovatel value
     * @throws \InvalidArgumentException
     * @param \StructType\Osoba[] $navrhovatel
     * @return \StructType\Konanie
     */
    public function setNavrhovatel(array $navrhovatel = array())
    {
        // validation for constraint: array
        if ('' !== ($navrhovatelArrayErrorMessage = self::validateNavrhovatelForArrayConstraintsFromSetNavrhovatel($navrhovatel))) {
            throw new \InvalidArgumentException($navrhovatelArrayErrorMessage, __LINE__);
        }
        $this->Navrhovatel = $navrhovatel;
        return $this;
    }
    /**
     * Add item to Navrhovatel value
     * @throws \InvalidArgumentException
     * @param \StructType\Osoba $item
     * @return \StructType\Konanie
     */
    public function addToNavrhovatel(\StructType\Osoba $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Osoba) {
            throw new \InvalidArgumentException(sprintf('The Navrhovatel property can only contain items of type \StructType\Osoba, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Navrhovatel[] = $item;
        return $this;
    }
    /**
     * Get Dlznik value
     * @return \StructType\Osoba|null
     */
    public function getDlznik()
    {
        return $this->Dlznik;
    }
    /**
     * Set Dlznik value
     * @param \StructType\Osoba $dlznik
     * @return \StructType\Konanie
     */
    public function setDlznik(\StructType\Osoba $dlznik = null)
    {
        $this->Dlznik = $dlznik;
        return $this;
    }
    /**
     * Get Sud value
     * @return \StructType\Sud|null
     */
    public function getSud()
    {
        return $this->Sud;
    }
    /**
     * Set Sud value
     * @param \StructType\Sud $sud
     * @return \StructType\Konanie
     */
    public function setSud(\StructType\Sud $sud = null)
    {
        $this->Sud = $sud;
        return $this;
    }
    /**
     * Get Sudca value
     * @return string|null
     */
    public function getSudca()
    {
        return $this->Sudca;
    }
    /**
     * Set Sudca value
     * @param string $sudca
     * @return \StructType\Konanie
     */
    public function setSudca($sudca = null)
    {
        // validation for constraint: string
        if (!is_null($sudca) && !is_string($sudca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sudca, true), gettype($sudca)), __LINE__);
        }
        $this->Sudca = $sudca;
        return $this;
    }
    /**
     * Get Spravca value
     * @return \StructType\Spravca|null
     */
    public function getSpravca()
    {
        return $this->Spravca;
    }
    /**
     * Set Spravca value
     * @param \StructType\Spravca $spravca
     * @return \StructType\Konanie
     */
    public function setSpravca(\StructType\Spravca $spravca = null)
    {
        $this->Spravca = $spravca;
        return $this;
    }
    /**
     * Get DatumZacatiaKonania value
     * @return string|null
     */
    public function getDatumZacatiaKonania()
    {
        return $this->DatumZacatiaKonania;
    }
    /**
     * Set DatumZacatiaKonania value
     * @param string $datumZacatiaKonania
     * @return \StructType\Konanie
     */
    public function setDatumZacatiaKonania($datumZacatiaKonania = null)
    {
        // validation for constraint: string
        if (!is_null($datumZacatiaKonania) && !is_string($datumZacatiaKonania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumZacatiaKonania, true), gettype($datumZacatiaKonania)), __LINE__);
        }
        $this->DatumZacatiaKonania = $datumZacatiaKonania;
        return $this;
    }
    /**
     * Get DatumZacatiaProcesu value
     * @return string|null
     */
    public function getDatumZacatiaProcesu()
    {
        return $this->DatumZacatiaProcesu;
    }
    /**
     * Set DatumZacatiaProcesu value
     * @param string $datumZacatiaProcesu
     * @return \StructType\Konanie
     */
    public function setDatumZacatiaProcesu($datumZacatiaProcesu = null)
    {
        // validation for constraint: string
        if (!is_null($datumZacatiaProcesu) && !is_string($datumZacatiaProcesu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datumZacatiaProcesu, true), gettype($datumZacatiaProcesu)), __LINE__);
        }
        $this->DatumZacatiaProcesu = $datumZacatiaProcesu;
        return $this;
    }
    /**
     * Get TypSpravcu value
     * @return string|null
     */
    public function getTypSpravcu()
    {
        return $this->TypSpravcu;
    }
    /**
     * Set TypSpravcu value
     * @uses \EnumType\TypSpravcuNaKonani::valueIsValid()
     * @uses \EnumType\TypSpravcuNaKonani::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typSpravcu
     * @return \StructType\Konanie
     */
    public function setTypSpravcu($typSpravcu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypSpravcuNaKonani::valueIsValid($typSpravcu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypSpravcuNaKonani', is_array($typSpravcu) ? implode(', ', $typSpravcu) : var_export($typSpravcu, true), implode(', ', \EnumType\TypSpravcuNaKonani::getValidValues())), __LINE__);
        }
        $this->TypSpravcu = $typSpravcu;
        return $this;
    }
    /**
     * Get TypPrideleniaSpravcu value
     * @return string|null
     */
    public function getTypPrideleniaSpravcu()
    {
        return $this->TypPrideleniaSpravcu;
    }
    /**
     * Set TypPrideleniaSpravcu value
     * @uses \EnumType\TypPrideleniaSpravcu::valueIsValid()
     * @uses \EnumType\TypPrideleniaSpravcu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typPrideleniaSpravcu
     * @return \StructType\Konanie
     */
    public function setTypPrideleniaSpravcu($typPrideleniaSpravcu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypPrideleniaSpravcu::valueIsValid($typPrideleniaSpravcu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypPrideleniaSpravcu', is_array($typPrideleniaSpravcu) ? implode(', ', $typPrideleniaSpravcu) : var_export($typPrideleniaSpravcu, true), implode(', ', \EnumType\TypPrideleniaSpravcu::getValidValues())), __LINE__);
        }
        $this->TypPrideleniaSpravcu = $typPrideleniaSpravcu;
        return $this;
    }
    /**
     * Get TypKonaniaPodlaUzemnejPlatnosti value
     * @return string|null
     */
    public function getTypKonaniaPodlaUzemnejPlatnosti()
    {
        return $this->TypKonaniaPodlaUzemnejPlatnosti;
    }
    /**
     * Set TypKonaniaPodlaUzemnejPlatnosti value
     * @param string $typKonaniaPodlaUzemnejPlatnosti
     * @return \StructType\Konanie
     */
    public function setTypKonaniaPodlaUzemnejPlatnosti($typKonaniaPodlaUzemnejPlatnosti = null)
    {
        // validation for constraint: string
        if (!is_null($typKonaniaPodlaUzemnejPlatnosti) && !is_string($typKonaniaPodlaUzemnejPlatnosti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typKonaniaPodlaUzemnejPlatnosti, true), gettype($typKonaniaPodlaUzemnejPlatnosti)), __LINE__);
        }
        $this->TypKonaniaPodlaUzemnejPlatnosti = $typKonaniaPodlaUzemnejPlatnosti;
        return $this;
    }
}
