<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Adresa StructType
 * Meta information extracted from the WSDL
 * - documentation: Obsahuje atribúty inštancie typu Adresa: ulica - ulica adresy supisneCislo - supisné číslo adresy orientacneCislo - orientačné číslo adresy obec - obec adresy psc - PSČ adresy krajina - krajina adresy
 * @subpackage Structs
 */
class Adresa extends AbstractStructBase
{
    /**
     * The Ulica
     * @var string
     */
    public $Ulica;
    /**
     * The SupisneCislo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SupisneCislo;
    /**
     * The OrientacneCislo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $OrientacneCislo;
    /**
     * The Obec
     * @var string
     */
    public $Obec;
    /**
     * The Psc
     * @var string
     */
    public $Psc;
    /**
     * The Krajina
     * @var string
     */
    public $Krajina;
    /**
     * Constructor method for Adresa
     * @uses Adresa::setUlica()
     * @uses Adresa::setSupisneCislo()
     * @uses Adresa::setOrientacneCislo()
     * @uses Adresa::setObec()
     * @uses Adresa::setPsc()
     * @uses Adresa::setKrajina()
     * @param string $ulica
     * @param string $supisneCislo
     * @param string $orientacneCislo
     * @param string $obec
     * @param string $psc
     * @param string $krajina
     */
    public function __construct($ulica = null, $supisneCislo = null, $orientacneCislo = null, $obec = null, $psc = null, $krajina = null)
    {
        $this
            ->setUlica($ulica)
            ->setSupisneCislo($supisneCislo)
            ->setOrientacneCislo($orientacneCislo)
            ->setObec($obec)
            ->setPsc($psc)
            ->setKrajina($krajina);
    }
    /**
     * Get Ulica value
     * @return string|null
     */
    public function getUlica()
    {
        return $this->Ulica;
    }
    /**
     * Set Ulica value
     * @param string $ulica
     * @return \StructType\Adresa
     */
    public function setUlica($ulica = null)
    {
        // validation for constraint: string
        if (!is_null($ulica) && !is_string($ulica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ulica, true), gettype($ulica)), __LINE__);
        }
        $this->Ulica = $ulica;
        return $this;
    }
    /**
     * Get SupisneCislo value
     * @return string|null
     */
    public function getSupisneCislo()
    {
        return $this->SupisneCislo;
    }
    /**
     * Set SupisneCislo value
     * @param string $supisneCislo
     * @return \StructType\Adresa
     */
    public function setSupisneCislo($supisneCislo = null)
    {
        // validation for constraint: string
        if (!is_null($supisneCislo) && !is_string($supisneCislo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supisneCislo, true), gettype($supisneCislo)), __LINE__);
        }
        $this->SupisneCislo = $supisneCislo;
        return $this;
    }
    /**
     * Get OrientacneCislo value
     * @return string|null
     */
    public function getOrientacneCislo()
    {
        return $this->OrientacneCislo;
    }
    /**
     * Set OrientacneCislo value
     * @param string $orientacneCislo
     * @return \StructType\Adresa
     */
    public function setOrientacneCislo($orientacneCislo = null)
    {
        // validation for constraint: string
        if (!is_null($orientacneCislo) && !is_string($orientacneCislo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orientacneCislo, true), gettype($orientacneCislo)), __LINE__);
        }
        $this->OrientacneCislo = $orientacneCislo;
        return $this;
    }
    /**
     * Get Obec value
     * @return string|null
     */
    public function getObec()
    {
        return $this->Obec;
    }
    /**
     * Set Obec value
     * @param string $obec
     * @return \StructType\Adresa
     */
    public function setObec($obec = null)
    {
        // validation for constraint: string
        if (!is_null($obec) && !is_string($obec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($obec, true), gettype($obec)), __LINE__);
        }
        $this->Obec = $obec;
        return $this;
    }
    /**
     * Get Psc value
     * @return string|null
     */
    public function getPsc()
    {
        return $this->Psc;
    }
    /**
     * Set Psc value
     * @param string $psc
     * @return \StructType\Adresa
     */
    public function setPsc($psc = null)
    {
        // validation for constraint: string
        if (!is_null($psc) && !is_string($psc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($psc, true), gettype($psc)), __LINE__);
        }
        $this->Psc = $psc;
        return $this;
    }
    /**
     * Get Krajina value
     * @return string|null
     */
    public function getKrajina()
    {
        return $this->Krajina;
    }
    /**
     * Set Krajina value
     * @param string $krajina
     * @return \StructType\Adresa
     */
    public function setKrajina($krajina = null)
    {
        // validation for constraint: string
        if (!is_null($krajina) && !is_string($krajina)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($krajina, true), gettype($krajina)), __LINE__);
        }
        $this->Krajina = $krajina;
        return $this;
    }
}
