<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for vyhladajKonanieRequest StructType
 * @subpackage Structs
 */
class VyhladajKonanieRequest extends AbstractStructBase
{
    /**
     * The Query
     * @var string
     */
    public $Query;
    /**
     * The Stranka
     * Meta information extracted from the WSDL
     * - default: 0
     * - minOccurs: 0
     * @var int
     */
    public $Stranka;
    /**
     * The VysledkovNaStranku
     * Meta information extracted from the WSDL
     * - default: 10
     * - minOccurs: 0
     * @var int
     */
    public $VysledkovNaStranku;
    /**
     * The TypTriedenia
     * Meta information extracted from the WSDL
     * - default: DatumPoslednejUdalosti
     * - minOccurs: 0
     * @var string
     */
    public $TypTriedenia;
    /**
     * Constructor method for vyhladajKonanieRequest
     * @uses VyhladajKonanieRequest::setQuery()
     * @uses VyhladajKonanieRequest::setStranka()
     * @uses VyhladajKonanieRequest::setVysledkovNaStranku()
     * @uses VyhladajKonanieRequest::setTypTriedenia()
     * @param string $query
     * @param int $stranka
     * @param int $vysledkovNaStranku
     * @param string $typTriedenia
     */
    public function __construct($query = null, $stranka = 0, $vysledkovNaStranku = 10, $typTriedenia = 'DatumPoslednejUdalosti')
    {
        $this
            ->setQuery($query)
            ->setStranka($stranka)
            ->setVysledkovNaStranku($vysledkovNaStranku)
            ->setTypTriedenia($typTriedenia);
    }
    /**
     * Get Query value
     * @return string|null
     */
    public function getQuery()
    {
        return $this->Query;
    }
    /**
     * Set Query value
     * @param string $query
     * @return \StructType\VyhladajKonanieRequest
     */
    public function setQuery($query = null)
    {
        // validation for constraint: string
        if (!is_null($query) && !is_string($query)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($query, true), gettype($query)), __LINE__);
        }
        $this->Query = $query;
        return $this;
    }
    /**
     * Get Stranka value
     * @return int|null
     */
    public function getStranka()
    {
        return $this->Stranka;
    }
    /**
     * Set Stranka value
     * @param int $stranka
     * @return \StructType\VyhladajKonanieRequest
     */
    public function setStranka($stranka = 0)
    {
        // validation for constraint: int
        if (!is_null($stranka) && !(is_int($stranka) || ctype_digit($stranka))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stranka, true), gettype($stranka)), __LINE__);
        }
        $this->Stranka = $stranka;
        return $this;
    }
    /**
     * Get VysledkovNaStranku value
     * @return int|null
     */
    public function getVysledkovNaStranku()
    {
        return $this->VysledkovNaStranku;
    }
    /**
     * Set VysledkovNaStranku value
     * @param int $vysledkovNaStranku
     * @return \StructType\VyhladajKonanieRequest
     */
    public function setVysledkovNaStranku($vysledkovNaStranku = 10)
    {
        // validation for constraint: int
        if (!is_null($vysledkovNaStranku) && !(is_int($vysledkovNaStranku) || ctype_digit($vysledkovNaStranku))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($vysledkovNaStranku, true), gettype($vysledkovNaStranku)), __LINE__);
        }
        $this->VysledkovNaStranku = $vysledkovNaStranku;
        return $this;
    }
    /**
     * Get TypTriedenia value
     * @return string|null
     */
    public function getTypTriedenia()
    {
        return $this->TypTriedenia;
    }
    /**
     * Set TypTriedenia value
     * @uses \EnumType\TypTriedenia::valueIsValid()
     * @uses \EnumType\TypTriedenia::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typTriedenia
     * @return \StructType\VyhladajKonanieRequest
     */
    public function setTypTriedenia($typTriedenia = 'DatumPoslednejUdalosti')
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypTriedenia::valueIsValid($typTriedenia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypTriedenia', is_array($typTriedenia) ? implode(', ', $typTriedenia) : var_export($typTriedenia, true), implode(', ', \EnumType\TypTriedenia::getValidValues())), __LINE__);
        }
        $this->TypTriedenia = $typTriedenia;
        return $this;
    }
}
