<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Osoba StructType
 * @subpackage Structs
 */
class Osoba extends AbstractStructBase
{
    /**
     * The Adresa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Adresa
     */
    public $Adresa;
    /**
     * The Telefon
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Telefon;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The BankovyUcet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\BankovyUcet
     */
    public $BankovyUcet;
    /**
     * Constructor method for Osoba
     * @uses Osoba::setAdresa()
     * @uses Osoba::setTelefon()
     * @uses Osoba::setEmail()
     * @uses Osoba::setBankovyUcet()
     * @param \StructType\Adresa $adresa
     * @param string $telefon
     * @param string $email
     * @param \StructType\BankovyUcet $bankovyUcet
     */
    public function __construct(\StructType\Adresa $adresa = null, $telefon = null, $email = null, \StructType\BankovyUcet $bankovyUcet = null)
    {
        $this
            ->setAdresa($adresa)
            ->setTelefon($telefon)
            ->setEmail($email)
            ->setBankovyUcet($bankovyUcet);
    }
    /**
     * Get Adresa value
     * @return \StructType\Adresa|null
     */
    public function getAdresa()
    {
        return $this->Adresa;
    }
    /**
     * Set Adresa value
     * @param \StructType\Adresa $adresa
     * @return \StructType\Osoba
     */
    public function setAdresa(\StructType\Adresa $adresa = null)
    {
        $this->Adresa = $adresa;
        return $this;
    }
    /**
     * Get Telefon value
     * @return string|null
     */
    public function getTelefon()
    {
        return $this->Telefon;
    }
    /**
     * Set Telefon value
     * @param string $telefon
     * @return \StructType\Osoba
     */
    public function setTelefon($telefon = null)
    {
        // validation for constraint: string
        if (!is_null($telefon) && !is_string($telefon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefon, true), gettype($telefon)), __LINE__);
        }
        $this->Telefon = $telefon;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\Osoba
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get BankovyUcet value
     * @return \StructType\BankovyUcet|null
     */
    public function getBankovyUcet()
    {
        return $this->BankovyUcet;
    }
    /**
     * Set BankovyUcet value
     * @param \StructType\BankovyUcet $bankovyUcet
     * @return \StructType\Osoba
     */
    public function setBankovyUcet(\StructType\BankovyUcet $bankovyUcet = null)
    {
        $this->BankovyUcet = $bankovyUcet;
        return $this;
    }
}
