<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ru-ws.justice.sk/ru-verejnost-ws/konanieService.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ru-ws.justice.sk/ru-verejnost-ws/konanieService.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Vyhladaj ServiceType
 */
$vyhladaj = new \ServiceType\Vyhladaj($options);
/**
 * Sample call for vyhladajKonanie operation/method
 */
if ($vyhladaj->vyhladajKonanie(new \StructType\VyhladajKonanieRequest()) !== false) {
    print_r($vyhladaj->getResult());
} else {
    print_r($vyhladaj->getLastError());
}
/**
 * Sample call for vyhladajPoslednuZmenuOd operation/method
 */
if ($vyhladaj->vyhladajPoslednuZmenuOd(new \StructType\VyhladajPoslednuZmenuOdRequest()) !== false) {
    print_r($vyhladaj->getResult());
} else {
    print_r($vyhladaj->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getKonanieDetailPodlaZnackyASudu operation/method
 */
if ($get->getKonanieDetailPodlaZnackyASudu(new \StructType\GetKonanieDetailPodlaZnackyASuduRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getZoznamSudov operation/method
 */
if ($get->getZoznamSudov(new \StructType\GetZoznamSudovRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getKonanieDetail operation/method
 */
if ($get->getKonanieDetail(new \StructType\GetKonanieDetailRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getKonaniePreObdobie operation/method
 */
if ($get->getKonaniePreObdobie(new \StructType\GetKonaniePreObdobieRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getKonaniePodlaICO operation/method
 */
if ($get->getKonaniePodlaICO(new \StructType\GetKonaniePodlaICORequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
